/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.apiextensions.v1.CustomResourceValidation;
import io.fabric8.kubernetes.api.model.v5_7.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.api.model.v5_7.apiextensions.v1.CustomResourceValidationFluentImpl;
import java.util.Objects;

public class CustomResourceValidationBuilder
extends CustomResourceValidationFluentImpl<CustomResourceValidationBuilder>
implements VisitableBuilder<CustomResourceValidation, CustomResourceValidationBuilder> {
    CustomResourceValidationFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceValidationBuilder() {
        this(true);
    }

    public CustomResourceValidationBuilder(Boolean validationEnabled) {
        this(new CustomResourceValidation(), validationEnabled);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceValidation(), validationEnabled);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, CustomResourceValidation instance) {
        this(fluent, instance, true);
    }

    public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent, CustomResourceValidation instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceValidationBuilder(CustomResourceValidation instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceValidationBuilder(CustomResourceValidation instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CustomResourceValidation build() {
        CustomResourceValidation buildable = new CustomResourceValidation(this.fluent.getOpenAPIV3Schema());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceValidationBuilder that = (CustomResourceValidationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

