/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v5_7.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.v5_7.SELinuxOptions;
import io.fabric8.kubernetes.api.model.v5_7.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.v5_7.SELinuxOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.SeccompProfile;
import io.fabric8.kubernetes.api.model.v5_7.SeccompProfileBuilder;
import io.fabric8.kubernetes.api.model.v5_7.SeccompProfileFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.Sysctl;
import io.fabric8.kubernetes.api.model.v5_7.SysctlBuilder;
import io.fabric8.kubernetes.api.model.v5_7.SysctlFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.WindowsSecurityContextOptions;
import io.fabric8.kubernetes.api.model.v5_7.WindowsSecurityContextOptionsBuilder;
import io.fabric8.kubernetes.api.model.v5_7.WindowsSecurityContextOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>>
extends BaseFluent<A>
implements PodSecurityContextFluent<A> {
    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private SeccompProfileBuilder seccompProfile;
    private List<Long> supplementalGroups = new ArrayList<Long>();
    private List<SysctlBuilder> sysctls = new ArrayList<SysctlBuilder>();
    private WindowsSecurityContextOptionsBuilder windowsOptions;

    public PodSecurityContextFluentImpl() {
    }

    public PodSecurityContextFluentImpl(PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup());
        this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSeccompProfile(instance.getSeccompProfile());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
        this.withWindowsOptions(instance.getWindowsOptions());
    }

    @Override
    public Long getFsGroup() {
        return this.fsGroup;
    }

    @Override
    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    @Override
    public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    @Override
    @Deprecated
    public A withNewFsGroupChangePolicy(String arg0) {
        return this.withFsGroupChangePolicy(new String(arg0));
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    @Deprecated
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public A withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new SELinuxOptionsBuilder().build());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    @Deprecated
    public SeccompProfile getSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public A withSeccompProfile(SeccompProfile seccompProfile) {
        this._visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile != null) {
            this.seccompProfile = new SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    @Override
    public A withNewSeccompProfile(String localhostProfile, String type) {
        return this.withSeccompProfile(new SeccompProfile(localhostProfile, type));
    }

    @Override
    public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
        return new SeccompProfileNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile());
    }

    @Override
    public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : new SeccompProfileBuilder().build());
    }

    @Override
    public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : item);
    }

    @Override
    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSupplementalGroups(Long ... items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @Override
    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    @Override
    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    @Override
    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    @Override
    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (this.supplementalGroups != null) {
            this._visitables.get("supplementalGroups").removeAll(this.supplementalGroups);
        }
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    @Override
    public A addToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        this._visitables.get("sysctls").add(index >= 0 ? index : this._visitables.get("sysctls").size(), builder);
        this.sysctls.add(index >= 0 ? index : this.sysctls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        if (index < 0 || index >= this._visitables.get("sysctls").size()) {
            this._visitables.get("sysctls").add(builder);
        } else {
            this._visitables.get("sysctls").set(index, builder);
        }
        if (index < 0 || index >= this.sysctls.size()) {
            this.sysctls.add(builder);
        } else {
            this.sysctls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSysctls(Sysctl ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSysctls(Collection<Sysctl> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSysctls(Sysctl ... items) {
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSysctls(Collection<Sysctl> items) {
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate) {
        if (this.sysctls == null) {
            return (A)this;
        }
        Iterator<SysctlBuilder> each = this.sysctls.iterator();
        Object visitables = this._visitables.get("sysctls");
        while (each.hasNext()) {
            SysctlBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Sysctl> getSysctls() {
        return PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public List<Sysctl> buildSysctls() {
        return PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    @Override
    public Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    @Override
    public Sysctl buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    @Override
    public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        for (SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        for (SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSysctls(List<Sysctl> sysctls) {
        if (this.sysctls != null) {
            this._visitables.get("sysctls").removeAll(this.sysctls);
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withSysctls(Sysctl ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
        }
        if (sysctls != null) {
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    @Override
    public A addNewSysctl(String name, String value) {
        return this.addToSysctls(new Sysctl(name, value));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctl() {
        return new SysctlsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(Sysctl item) {
        return new SysctlsNestedImpl(-1, item);
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index, Sysctl item) {
        return new SysctlsNestedImpl(index, item);
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.test(this.sysctls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    @Deprecated
    public WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
        this._visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions != null) {
            this.windowsOptions = new WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    @Override
    public A withNewWindowsOptions(String gmsaCredentialSpec, String gmsaCredentialSpecName, String runAsUserName) {
        return this.withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, runAsUserName));
    }

    @Override
    public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return new WindowsOptionsNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions());
    }

    @Override
    public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : new WindowsSecurityContextOptionsBuilder().build());
    }

    @Override
    public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl)o;
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.fsGroupChangePolicy != null ? !this.fsGroupChangePolicy.equals(that.fsGroupChangePolicy) : that.fsGroupChangePolicy != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        if (this.seccompProfile != null ? !this.seccompProfile.equals(that.seccompProfile) : that.seccompProfile != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.sysctls != null ? !this.sysctls.equals(that.sysctls) : that.sysctls != null) {
            return false;
        }
        return !(this.windowsOptions != null ? !this.windowsOptions.equals(that.windowsOptions) : that.windowsOptions != null);
    }

    public int hashCode() {
        return Objects.hash(this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.sysctls, this.windowsOptions, super.hashCode());
    }

    public class WindowsOptionsNestedImpl<N>
    extends WindowsSecurityContextOptionsFluentImpl<PodSecurityContextFluent.WindowsOptionsNested<N>>
    implements PodSecurityContextFluent.WindowsOptionsNested<N>,
    Nested<N> {
        private final WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNestedImpl(WindowsSecurityContextOptions item) {
            this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
        }

        WindowsOptionsNestedImpl() {
            this.builder = new WindowsSecurityContextOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withWindowsOptions(this.builder.build());
        }

        @Override
        public N endWindowsOptions() {
            return this.and();
        }
    }

    public class SysctlsNestedImpl<N>
    extends SysctlFluentImpl<PodSecurityContextFluent.SysctlsNested<N>>
    implements PodSecurityContextFluent.SysctlsNested<N>,
    Nested<N> {
        private final SysctlBuilder builder;
        private final int index;

        SysctlsNestedImpl(int index, Sysctl item) {
            this.index = index;
            this.builder = new SysctlBuilder(this, item);
        }

        SysctlsNestedImpl() {
            this.index = -1;
            this.builder = new SysctlBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.setToSysctls(this.index, this.builder.build());
        }

        @Override
        public N endSysctl() {
            return this.and();
        }
    }

    public class SeccompProfileNestedImpl<N>
    extends SeccompProfileFluentImpl<PodSecurityContextFluent.SeccompProfileNested<N>>
    implements PodSecurityContextFluent.SeccompProfileNested<N>,
    Nested<N> {
        private final SeccompProfileBuilder builder;

        SeccompProfileNestedImpl(SeccompProfile item) {
            this.builder = new SeccompProfileBuilder(this, item);
        }

        SeccompProfileNestedImpl() {
            this.builder = new SeccompProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withSeccompProfile(this.builder.build());
        }

        @Override
        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>>
    implements PodSecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }
}

