/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.APIServiceSpec;
import io.fabric8.kubernetes.api.model.v5_7.APIServiceSpecFluent;
import io.fabric8.kubernetes.api.model.v5_7.ServiceReference;
import io.fabric8.kubernetes.api.model.v5_7.ServiceReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ServiceReferenceFluentImpl;
import java.util.Objects;

public class APIServiceSpecFluentImpl<A extends APIServiceSpecFluent<A>>
extends BaseFluent<A>
implements APIServiceSpecFluent<A> {
    private String caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public APIServiceSpecFluentImpl() {
    }

    public APIServiceSpecFluentImpl(APIServiceSpec instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withGroup(instance.getGroup());
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withService(instance.getService());
        this.withVersion(instance.getVersion());
        this.withVersionPriority(instance.getVersionPriority());
    }

    @Override
    public String getCaBundle() {
        return this.caBundle;
    }

    @Override
    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    @Override
    @Deprecated
    public A withNewCaBundle(String arg0) {
        return this.withCaBundle(new String(arg0));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String arg0) {
        return this.withGroup(new String(arg0));
    }

    @Override
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    @Override
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    @Override
    public Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    @Override
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @Override
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    @Override
    @Deprecated
    public ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ServiceReference service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public A withNewService(String name, String namespace, Integer port) {
        return this.withService(new ServiceReference(name, namespace, port));
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ServiceReferenceBuilder().build());
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    @Override
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    @Override
    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    @Override
    public Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServiceSpecFluentImpl that = (APIServiceSpecFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.groupPriorityMinimum != null ? !this.groupPriorityMinimum.equals(that.groupPriorityMinimum) : that.groupPriorityMinimum != null) {
            return false;
        }
        if (this.insecureSkipTLSVerify != null ? !this.insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) : that.insecureSkipTLSVerify != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.versionPriority != null ? !this.versionPriority.equals(that.versionPriority) : that.versionPriority != null);
    }

    public int hashCode() {
        return Objects.hash(this.caBundle, this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority, super.hashCode());
    }

    public class ServiceNestedImpl<N>
    extends ServiceReferenceFluentImpl<APIServiceSpecFluent.ServiceNested<N>>
    implements APIServiceSpecFluent.ServiceNested<N>,
    Nested<N> {
        private final ServiceReferenceBuilder builder;

        ServiceNestedImpl(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServiceSpecFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

