/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.machineconfiguration;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.KubeletConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class KubeletConfigHandler
implements ResourceHandler<KubeletConfig, KubeletConfigBuilder> {
    @Override
    public String getKind() {
        return KubeletConfig.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "machineconfiguration.openshift.io/v1";
    }

    @Override
    public KubeletConfig create(OkHttpClient client, Config config, String namespace, KubeletConfig item, boolean dryRun) {
        return (KubeletConfig)((WritableOperation)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new KubeletConfig[0]);
    }

    @Override
    public KubeletConfig replace(OkHttpClient client, Config config, String namespace, KubeletConfig item, boolean dryRun) {
        return ((WritableOperation)((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public KubeletConfig reload(OkHttpClient client, Config config, String namespace, KubeletConfig item) {
        return (KubeletConfig)((Gettable)((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public KubeletConfigBuilder edit(KubeletConfig item) {
        return new KubeletConfigBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, KubeletConfig item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubeletConfig item, Watcher<KubeletConfig> watcher) {
        return ((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubeletConfig item, String resourceVersion, Watcher<KubeletConfig> watcher) {
        return ((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubeletConfig item, ListOptions options, Watcher<KubeletConfig> watcher) {
        return ((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public KubeletConfig waitUntilReady(OkHttpClient client, Config config, String namespace, KubeletConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (KubeletConfig)((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public KubeletConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, KubeletConfig item, Predicate<KubeletConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (KubeletConfig)((Resource)new KubeletConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

