/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.internal.readiness;

import io.fabric8.kubernetes.api.model.v5_5.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_5.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_5.utils.Utils;
import io.fabric8.openshift.api.model.v5_5.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_5.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.v5_5.DeploymentConfigStatus;

public class OpenShiftReadiness
extends Readiness {
    private static final String OPENSHIFT_READINESS_APPLICABLE_RESOURCES = "Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController, DeploymentConfig";

    public static OpenShiftReadiness getInstance() {
        return OpenShiftReadinessHolder.INSTANCE;
    }

    @Override
    protected boolean isReadinessApplicable(HasMetadata item) {
        return super.isReadinessApplicable(item) || item instanceof DeploymentConfig;
    }

    @Override
    protected boolean isResourceReady(HasMetadata item) {
        if (item instanceof DeploymentConfig) {
            return OpenShiftReadiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        return super.isResourceReady(item);
    }

    @Override
    protected String getReadinessResourcesList() {
        return OPENSHIFT_READINESS_APPLICABLE_RESOURCES;
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    private static class OpenShiftReadinessHolder {
        public static final OpenShiftReadiness INSTANCE = new OpenShiftReadiness();

        private OpenShiftReadinessHolder() {
        }
    }
}

