/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.internal;

import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_5.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.ClusterOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_5.utils.Serialization;
import io.fabric8.openshift.api.model.v5_5.ClusterVersion;
import io.fabric8.openshift.api.model.v5_5.ClusterVersionList;
import java.io.IOException;
import java.text.ParseException;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class OpenShiftClusterOperationsImpl
extends ClusterOperationsImpl {
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    public static final String OPENSHIFT4_VERSION_ENDPOINT = "apis/config.openshift.io/v1/clusterversions";

    public OpenShiftClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(client, config, item);
    }

    @Override
    public VersionInfo fetchVersion() {
        try {
            return super.fetchVersion();
        }
        catch (KubernetesClientException | NullPointerException exception) {
            try {
                return this.fetchOpenshift4Version();
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }

    private VersionInfo fetchOpenshift4Version() throws IOException, ParseException {
        ClusterVersionList clusterVersionList;
        Response response = this.handleVersionGet(this.getRequest(OPENSHIFT4_VERSION_ENDPOINT));
        if (response.isSuccessful() && response.body() != null && !(clusterVersionList = (ClusterVersionList)Serialization.jsonMapper().readValue(response.body().string(), ClusterVersionList.class)).getItems().isEmpty()) {
            return OpenShiftClusterOperationsImpl.parseVersionInfoFromClusterVersion(clusterVersionList.getItems().get(0));
        }
        return null;
    }

    private static VersionInfo parseVersionInfoFromClusterVersion(ClusterVersion clusterVersion) throws ParseException {
        String[] versionParts = clusterVersion.getStatus().getDesired().getVersion().split("\\.");
        VersionInfo.Builder versionInfoBuilder = new VersionInfo.Builder();
        if (versionParts.length > 2) {
            versionInfoBuilder.withMajor(versionParts[0]);
            versionInfoBuilder.withMinor(versionParts[1] + "." + versionParts[2]);
        }
        versionInfoBuilder.withBuildDate(clusterVersion.getMetadata().getCreationTimestamp());
        return versionInfoBuilder.build();
    }
}

