/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.route;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.Route;
import io.fabric8.openshift.api.model.v5_5.RouteBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.route.RouteOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RouteHandler
implements ResourceHandler<Route, RouteBuilder> {
    @Override
    public String getKind() {
        return Route.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "route.openshift.io/v1";
    }

    @Override
    public Route create(OkHttpClient client, Config config, String namespace, Route item, boolean dryRun) {
        return (Route)((WritableOperation)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Route[0]);
    }

    @Override
    public Route replace(OkHttpClient client, Config config, String namespace, Route item, boolean dryRun) {
        return ((WritableOperation)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Route reload(OkHttpClient client, Config config, String namespace, Route item) {
        return (Route)((Gettable)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RouteBuilder edit(Route item) {
        return new RouteBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Route item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, Watcher<Route> watcher) {
        return ((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, String resourceVersion, Watcher<Route> watcher) {
        return ((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, ListOptions options, Watcher<Route> watcher) {
        return ((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Route waitUntilReady(OkHttpClient client, Config config, String namespace, Route item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Route)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Route waitUntilCondition(OkHttpClient client, Config config, String namespace, Route item, Predicate<Route> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Route)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

