/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.oauth;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.OAuthClient;
import io.fabric8.openshift.api.model.v5_5.OAuthClientBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.oauth.OAuthClientOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthClientHandler
implements ResourceHandler<OAuthClient, OAuthClientBuilder> {
    @Override
    public String getKind() {
        return OAuthClient.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "oauth.openshift.io/v1";
    }

    @Override
    public OAuthClient create(OkHttpClient client, Config config, String namespace, OAuthClient item, boolean dryRun) {
        return (OAuthClient)((WritableOperation)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new OAuthClient[0]);
    }

    @Override
    public OAuthClient replace(OkHttpClient client, Config config, String namespace, OAuthClient item, boolean dryRun) {
        return ((WritableOperation)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public OAuthClient reload(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)((Gettable)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public OAuthClientBuilder edit(OAuthClient item) {
        return new OAuthClientBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OAuthClient item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, Watcher<OAuthClient> watcher) {
        return ((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, String resourceVersion, Watcher<OAuthClient> watcher) {
        return ((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, ListOptions options, Watcher<OAuthClient> watcher) {
        return ((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public OAuthClient waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthClient item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public OAuthClient waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthClient item, Predicate<OAuthClient> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

