/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.machine;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.Machine;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.machine.MachineOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class MachineHandler
implements ResourceHandler<Machine, MachineBuilder> {
    @Override
    public String getKind() {
        return Machine.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "machine.openshift.io/v1beta1";
    }

    @Override
    public Machine create(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
        return (Machine)((WritableOperation)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Machine[0]);
    }

    @Override
    public Machine replace(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
        return ((WritableOperation)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Machine reload(OkHttpClient client, Config config, String namespace, Machine item) {
        return (Machine)((Gettable)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public MachineBuilder edit(Machine item) {
        return new MachineBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Machine item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, String resourceVersion, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, ListOptions options, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Machine waitUntilReady(OkHttpClient client, Config config, String namespace, Machine item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Machine)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Machine waitUntilCondition(OkHttpClient client, Config config, String namespace, Machine item, Predicate<Machine> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Machine)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

