/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.image;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.ImageStream;
import io.fabric8.openshift.api.model.v5_5.ImageStreamBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.image.ImageStreamOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageStreamHandler
implements ResourceHandler<ImageStream, ImageStreamBuilder> {
    @Override
    public String getKind() {
        return ImageStream.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public ImageStream create(OkHttpClient client, Config config, String namespace, ImageStream item, boolean dryRun) {
        return (ImageStream)((WritableOperation)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new ImageStream[0]);
    }

    @Override
    public ImageStream replace(OkHttpClient client, Config config, String namespace, ImageStream item, boolean dryRun) {
        return ((WritableOperation)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public ImageStream reload(OkHttpClient client, Config config, String namespace, ImageStream item) {
        return (ImageStream)((Gettable)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageStreamBuilder edit(ImageStream item) {
        return new ImageStreamBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ImageStream item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, String resourceVersion, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageStream item, ListOptions options, Watcher<ImageStream> watcher) {
        return ((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ImageStream waitUntilReady(OkHttpClient client, Config config, String namespace, ImageStream item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ImageStream waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageStream item, Predicate<ImageStream> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageStream)((Resource)new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

