/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.image;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.Image;
import io.fabric8.openshift.api.model.v5_5.ImageBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.image.ImageOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageHandler
implements ResourceHandler<Image, ImageBuilder> {
    @Override
    public String getKind() {
        return Image.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public Image create(OkHttpClient client, Config config, String namespace, Image item, boolean dryRun) {
        return (Image)((WritableOperation)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Image[0]);
    }

    @Override
    public Image replace(OkHttpClient client, Config config, String namespace, Image item, boolean dryRun) {
        return ((WritableOperation)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Image reload(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Gettable)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageBuilder edit(Image item) {
        return new ImageBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Image item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, String resourceVersion, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, ListOptions options, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Image waitUntilReady(OkHttpClient client, Config config, String namespace, Image item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Image waitUntilCondition(OkHttpClient client, Config config, String namespace, Image item, Predicate<Image> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

