/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_5.handlers.core;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_5.storageversionmigrator.v1alpha1.StorageState;
import io.fabric8.openshift.api.model.v5_5.storageversionmigrator.v1alpha1.StorageStateBuilder;
import io.fabric8.openshift.clnt.v5_5.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_5.dsl.internal.core.StorageStateOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StorageStateHandler
implements ResourceHandler<StorageState, StorageStateBuilder> {
    @Override
    public String getKind() {
        return StorageState.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "migration.k8s.io/v1alpha1";
    }

    @Override
    public StorageState create(OkHttpClient client, Config config, String namespace, StorageState item, boolean dryRun) {
        return (StorageState)((WritableOperation)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new StorageState[0]);
    }

    @Override
    public StorageState replace(OkHttpClient client, Config config, String namespace, StorageState item, boolean dryRun) {
        return ((WritableOperation)((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public StorageState reload(OkHttpClient client, Config config, String namespace, StorageState item) {
        return (StorageState)((Gettable)((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StorageStateBuilder edit(StorageState item) {
        return new StorageStateBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, StorageState item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, Watcher<StorageState> watcher) {
        return ((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, String resourceVersion, Watcher<StorageState> watcher) {
        return ((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, ListOptions options, Watcher<StorageState> watcher) {
        return ((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public StorageState waitUntilReady(OkHttpClient client, Config config, String namespace, StorageState item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageState)((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StorageState waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageState item, Predicate<StorageState> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageState)((Resource)new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

