/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.openshift.api.model.v5_5.operator.v1alpha1.RepositoryDigestMirrors;
import io.fabric8.openshift.api.model.v5_5.operator.v1alpha1.RepositoryDigestMirrorsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RepositoryDigestMirrorsFluentImpl<A extends RepositoryDigestMirrorsFluent<A>>
extends BaseFluent<A>
implements RepositoryDigestMirrorsFluent<A> {
    private List<String> mirrors = new ArrayList<String>();
    private String source;

    public RepositoryDigestMirrorsFluentImpl() {
    }

    public RepositoryDigestMirrorsFluentImpl(RepositoryDigestMirrors instance) {
        this.withMirrors(instance.getMirrors());
        this.withSource(instance.getSource());
    }

    @Override
    public A addToMirrors(int index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMirrors(int index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMirrors(String ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMirrors(Collection<String> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(String ... items) {
        for (String item : items) {
            if (this.mirrors == null) continue;
            this.mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMirrors(Collection<String> items) {
        for (String item : items) {
            if (this.mirrors == null) continue;
            this.mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMirrors() {
        return this.mirrors;
    }

    @Override
    public String getMirror(int index) {
        return this.mirrors.get(index);
    }

    @Override
    public String getFirstMirror() {
        return this.mirrors.get(0);
    }

    @Override
    public String getLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1);
    }

    @Override
    public String getMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMirrors(List<String> mirrors) {
        if (this.mirrors != null) {
            this._visitables.get("mirrors").removeAll(this.mirrors);
        }
        if (mirrors != null) {
            this.mirrors = new ArrayList<String>();
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)this;
    }

    @Override
    public A withMirrors(String ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
        }
        if (mirrors != null) {
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    @Override
    public A addNewMirror(String arg0) {
        return this.addToMirrors(new String(arg0));
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public A withSource(String source) {
        this.source = source;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    @Deprecated
    public A withNewSource(String arg0) {
        return this.withSource(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryDigestMirrorsFluentImpl that = (RepositoryDigestMirrorsFluentImpl)o;
        if (this.mirrors != null ? !this.mirrors.equals(that.mirrors) : that.mirrors != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        return Objects.hash(this.mirrors, this.source, super.hashCode());
    }
}

