/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_5.operator.v1.Storage;
import io.fabric8.openshift.api.model.v5_5.operator.v1.StorageFluent;
import io.fabric8.openshift.api.model.v5_5.operator.v1.StorageFluentImpl;
import java.util.Objects;

public class StorageBuilder
extends StorageFluentImpl<StorageBuilder>
implements VisitableBuilder<Storage, StorageBuilder> {
    StorageFluent<?> fluent;
    Boolean validationEnabled;

    public StorageBuilder() {
        this(true);
    }

    public StorageBuilder(Boolean validationEnabled) {
        this(new Storage(), validationEnabled);
    }

    public StorageBuilder(StorageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StorageBuilder(StorageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Storage(), validationEnabled);
    }

    public StorageBuilder(StorageFluent<?> fluent, Storage instance) {
        this(fluent, instance, true);
    }

    public StorageBuilder(StorageFluent<?> fluent, Storage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public StorageBuilder(Storage instance) {
        this(instance, (Boolean)true);
    }

    public StorageBuilder(Storage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Storage build() {
        Storage buildable = new Storage(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageBuilder that = (StorageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

