/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_5.miscellaneous.metal3.v1alpha1.NIC;
import io.fabric8.openshift.api.model.v5_5.miscellaneous.metal3.v1alpha1.NICFluent;
import io.fabric8.openshift.api.model.v5_5.miscellaneous.metal3.v1alpha1.NICFluentImpl;
import java.util.Objects;

public class NICBuilder
extends NICFluentImpl<NICBuilder>
implements VisitableBuilder<NIC, NICBuilder> {
    NICFluent<?> fluent;
    Boolean validationEnabled;

    public NICBuilder() {
        this(true);
    }

    public NICBuilder(Boolean validationEnabled) {
        this(new NIC(), validationEnabled);
    }

    public NICBuilder(NICFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NICBuilder(NICFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NIC(), validationEnabled);
    }

    public NICBuilder(NICFluent<?> fluent, NIC instance) {
        this(fluent, instance, true);
    }

    public NICBuilder(NICFluent<?> fluent, NIC instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIp(instance.getIp());
        fluent.withMac(instance.getMac());
        fluent.withModel(instance.getModel());
        fluent.withName(instance.getName());
        fluent.withPxe(instance.getPxe());
        fluent.withSpeedGbps(instance.getSpeedGbps());
        fluent.withVlanId(instance.getVlanId());
        fluent.withVlans(instance.getVlans());
        this.validationEnabled = validationEnabled;
    }

    public NICBuilder(NIC instance) {
        this(instance, (Boolean)true);
    }

    public NICBuilder(NIC instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIp(instance.getIp());
        this.withMac(instance.getMac());
        this.withModel(instance.getModel());
        this.withName(instance.getName());
        this.withPxe(instance.getPxe());
        this.withSpeedGbps(instance.getSpeedGbps());
        this.withVlanId(instance.getVlanId());
        this.withVlans(instance.getVlans());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NIC build() {
        NIC buildable = new NIC(this.fluent.getIp(), this.fluent.getMac(), this.fluent.getModel(), this.fluent.getName(), this.fluent.getPxe(), this.fluent.getSpeedGbps(), this.fluent.getVlanId(), this.fluent.getVlans());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NICBuilder that = (NICBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

