/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_5.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_5.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineSetSpec;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineSetSpecFluent;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineTemplateSpec;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineTemplateSpecBuilder;
import io.fabric8.openshift.api.model.v5_5.machine.v1beta1.MachineTemplateSpecFluentImpl;
import java.util.Objects;

public class MachineSetSpecFluentImpl<A extends MachineSetSpecFluent<A>>
extends BaseFluent<A>
implements MachineSetSpecFluent<A> {
    private String deletePolicy;
    private Integer minReadySeconds;
    private Integer replicas;
    private LabelSelectorBuilder selector;
    private MachineTemplateSpecBuilder template;

    public MachineSetSpecFluentImpl() {
    }

    public MachineSetSpecFluentImpl(MachineSetSpec instance) {
        this.withDeletePolicy(instance.getDeletePolicy());
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public String getDeletePolicy() {
        return this.deletePolicy;
    }

    @Override
    public A withDeletePolicy(String deletePolicy) {
        this.deletePolicy = deletePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDeletePolicy() {
        return this.deletePolicy != null;
    }

    @Override
    @Deprecated
    public A withNewDeletePolicy(String arg0) {
        return this.withDeletePolicy(new String(arg0));
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public MachineSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public MachineSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public MachineSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public MachineSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public MachineSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public MachineTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public MachineTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(MachineTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new MachineTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public MachineSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public MachineSetSpecFluent.TemplateNested<A> withNewTemplateLike(MachineTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public MachineSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public MachineSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new MachineTemplateSpecBuilder().build());
    }

    @Override
    public MachineSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(MachineTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineSetSpecFluentImpl that = (MachineSetSpecFluentImpl)o;
        if (this.deletePolicy != null ? !this.deletePolicy.equals(that.deletePolicy) : that.deletePolicy != null) {
            return false;
        }
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public int hashCode() {
        return Objects.hash(this.deletePolicy, this.minReadySeconds, this.replicas, this.selector, this.template, super.hashCode());
    }

    public class TemplateNestedImpl<N>
    extends MachineTemplateSpecFluentImpl<MachineSetSpecFluent.TemplateNested<N>>
    implements MachineSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final MachineTemplateSpecBuilder builder;

        TemplateNestedImpl(MachineTemplateSpec item) {
            this.builder = new MachineTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new MachineTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<MachineSetSpecFluent.SelectorNested<N>>
    implements MachineSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

