/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.GPULimit;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.GPULimitBuilder;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.GPULimitFluentImpl;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.ResourceLimits;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.ResourceLimitsFluent;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.ResourceRange;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.ResourceRangeBuilder;
import io.fabric8.openshift.api.model.v5_5.clusterautoscaling.v1.ResourceRangeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceLimitsFluentImpl<A extends ResourceLimitsFluent<A>>
extends BaseFluent<A>
implements ResourceLimitsFluent<A> {
    private ResourceRangeBuilder cores;
    private List<GPULimitBuilder> gpus = new ArrayList<GPULimitBuilder>();
    private Integer maxNodesTotal;
    private ResourceRangeBuilder memory;

    public ResourceLimitsFluentImpl() {
    }

    public ResourceLimitsFluentImpl(ResourceLimits instance) {
        this.withCores(instance.getCores());
        this.withGpus(instance.getGpus());
        this.withMaxNodesTotal(instance.getMaxNodesTotal());
        this.withMemory(instance.getMemory());
    }

    @Override
    @Deprecated
    public ResourceRange getCores() {
        return this.cores != null ? this.cores.build() : null;
    }

    @Override
    public ResourceRange buildCores() {
        return this.cores != null ? this.cores.build() : null;
    }

    @Override
    public A withCores(ResourceRange cores) {
        this._visitables.get("cores").remove(this.cores);
        if (cores != null) {
            this.cores = new ResourceRangeBuilder(cores);
            this._visitables.get("cores").add(this.cores);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCores() {
        return this.cores != null;
    }

    @Override
    public A withNewCores(Integer max, Integer min) {
        return this.withCores(new ResourceRange(max, min));
    }

    @Override
    public ResourceLimitsFluent.CoresNested<A> withNewCores() {
        return new CoresNestedImpl();
    }

    @Override
    public ResourceLimitsFluent.CoresNested<A> withNewCoresLike(ResourceRange item) {
        return new CoresNestedImpl(item);
    }

    @Override
    public ResourceLimitsFluent.CoresNested<A> editCores() {
        return this.withNewCoresLike(this.getCores());
    }

    @Override
    public ResourceLimitsFluent.CoresNested<A> editOrNewCores() {
        return this.withNewCoresLike(this.getCores() != null ? this.getCores() : new ResourceRangeBuilder().build());
    }

    @Override
    public ResourceLimitsFluent.CoresNested<A> editOrNewCoresLike(ResourceRange item) {
        return this.withNewCoresLike(this.getCores() != null ? this.getCores() : item);
    }

    @Override
    public A addToGpus(int index, GPULimit item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<GPULimitBuilder>();
        }
        GPULimitBuilder builder = new GPULimitBuilder(item);
        this._visitables.get("gpus").add(index >= 0 ? index : this._visitables.get("gpus").size(), builder);
        this.gpus.add(index >= 0 ? index : this.gpus.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGpus(int index, GPULimit item) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<GPULimitBuilder>();
        }
        GPULimitBuilder builder = new GPULimitBuilder(item);
        if (index < 0 || index >= this._visitables.get("gpus").size()) {
            this._visitables.get("gpus").add(builder);
        } else {
            this._visitables.get("gpus").set(index, builder);
        }
        if (index < 0 || index >= this.gpus.size()) {
            this.gpus.add(builder);
        } else {
            this.gpus.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGpus(GPULimit ... items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<GPULimitBuilder>();
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGpus(Collection<GPULimit> items) {
        if (this.gpus == null) {
            this.gpus = new ArrayList<GPULimitBuilder>();
        }
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").add(builder);
            this.gpus.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGpus(GPULimit ... items) {
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").remove(builder);
            if (this.gpus == null) continue;
            this.gpus.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGpus(Collection<GPULimit> items) {
        for (GPULimit item : items) {
            GPULimitBuilder builder = new GPULimitBuilder(item);
            this._visitables.get("gpus").remove(builder);
            if (this.gpus == null) continue;
            this.gpus.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGpus(Predicate<GPULimitBuilder> predicate) {
        if (this.gpus == null) {
            return (A)this;
        }
        Iterator<GPULimitBuilder> each = this.gpus.iterator();
        Object visitables = this._visitables.get("gpus");
        while (each.hasNext()) {
            GPULimitBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GPULimit> getGpus() {
        return ResourceLimitsFluentImpl.build(this.gpus);
    }

    @Override
    public List<GPULimit> buildGpus() {
        return ResourceLimitsFluentImpl.build(this.gpus);
    }

    @Override
    public GPULimit buildGpus(int index) {
        return this.gpus.get(index).build();
    }

    @Override
    public GPULimit buildFirstGpus() {
        return this.gpus.get(0).build();
    }

    @Override
    public GPULimit buildLastGpus() {
        return this.gpus.get(this.gpus.size() - 1).build();
    }

    @Override
    public GPULimit buildMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        for (GPULimitBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        for (GPULimitBuilder item : this.gpus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGpus(List<GPULimit> gpus) {
        if (this.gpus != null) {
            this._visitables.get("gpus").removeAll(this.gpus);
        }
        if (gpus != null) {
            this.gpus = new ArrayList<GPULimitBuilder>();
            for (GPULimit item : gpus) {
                this.addToGpus(item);
            }
        } else {
            this.gpus = null;
        }
        return (A)this;
    }

    @Override
    public A withGpus(GPULimit ... gpus) {
        if (this.gpus != null) {
            this.gpus.clear();
        }
        if (gpus != null) {
            for (GPULimit item : gpus) {
                this.addToGpus(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGpus() {
        return this.gpus != null && !this.gpus.isEmpty();
    }

    @Override
    public A addNewGpus(Integer max, Integer min, String type) {
        return this.addToGpus(new GPULimit(max, min, type));
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> addNewGpus() {
        return new GpusNestedImpl();
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> addNewGpusLike(GPULimit item) {
        return new GpusNestedImpl(-1, item);
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> setNewGpusLike(int index, GPULimit item) {
        return new GpusNestedImpl(index, item);
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> editGpus(int index) {
        if (this.gpus.size() <= index) {
            throw new RuntimeException("Can't edit gpus. Index exceeds size.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> editFirstGpus() {
        if (this.gpus.size() == 0) {
            throw new RuntimeException("Can't edit first gpus. The list is empty.");
        }
        return this.setNewGpusLike(0, this.buildGpus(0));
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> editLastGpus() {
        int index = this.gpus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last gpus. The list is empty.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    @Override
    public ResourceLimitsFluent.GpusNested<A> editMatchingGpus(Predicate<GPULimitBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.gpus.size(); ++i) {
            if (!predicate.test(this.gpus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching gpus. No match found.");
        }
        return this.setNewGpusLike(index, this.buildGpus(index));
    }

    @Override
    public Integer getMaxNodesTotal() {
        return this.maxNodesTotal;
    }

    @Override
    public A withMaxNodesTotal(Integer maxNodesTotal) {
        this.maxNodesTotal = maxNodesTotal;
        return (A)this;
    }

    @Override
    public Boolean hasMaxNodesTotal() {
        return this.maxNodesTotal != null;
    }

    @Override
    @Deprecated
    public ResourceRange getMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    @Override
    public ResourceRange buildMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    @Override
    public A withMemory(ResourceRange memory) {
        this._visitables.get("memory").remove(this.memory);
        if (memory != null) {
            this.memory = new ResourceRangeBuilder(memory);
            this._visitables.get("memory").add(this.memory);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMemory() {
        return this.memory != null;
    }

    @Override
    public A withNewMemory(Integer max, Integer min) {
        return this.withMemory(new ResourceRange(max, min));
    }

    @Override
    public ResourceLimitsFluent.MemoryNested<A> withNewMemory() {
        return new MemoryNestedImpl();
    }

    @Override
    public ResourceLimitsFluent.MemoryNested<A> withNewMemoryLike(ResourceRange item) {
        return new MemoryNestedImpl(item);
    }

    @Override
    public ResourceLimitsFluent.MemoryNested<A> editMemory() {
        return this.withNewMemoryLike(this.getMemory());
    }

    @Override
    public ResourceLimitsFluent.MemoryNested<A> editOrNewMemory() {
        return this.withNewMemoryLike(this.getMemory() != null ? this.getMemory() : new ResourceRangeBuilder().build());
    }

    @Override
    public ResourceLimitsFluent.MemoryNested<A> editOrNewMemoryLike(ResourceRange item) {
        return this.withNewMemoryLike(this.getMemory() != null ? this.getMemory() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLimitsFluentImpl that = (ResourceLimitsFluentImpl)o;
        if (this.cores != null ? !this.cores.equals(that.cores) : that.cores != null) {
            return false;
        }
        if (this.gpus != null ? !this.gpus.equals(that.gpus) : that.gpus != null) {
            return false;
        }
        if (this.maxNodesTotal != null ? !this.maxNodesTotal.equals(that.maxNodesTotal) : that.maxNodesTotal != null) {
            return false;
        }
        return !(this.memory != null ? !this.memory.equals(that.memory) : that.memory != null);
    }

    public int hashCode() {
        return Objects.hash(this.cores, this.gpus, this.maxNodesTotal, this.memory, super.hashCode());
    }

    public class MemoryNestedImpl<N>
    extends ResourceRangeFluentImpl<ResourceLimitsFluent.MemoryNested<N>>
    implements ResourceLimitsFluent.MemoryNested<N>,
    Nested<N> {
        private final ResourceRangeBuilder builder;

        MemoryNestedImpl(ResourceRange item) {
            this.builder = new ResourceRangeBuilder(this, item);
        }

        MemoryNestedImpl() {
            this.builder = new ResourceRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluentImpl.this.withMemory(this.builder.build());
        }

        @Override
        public N endMemory() {
            return this.and();
        }
    }

    public class GpusNestedImpl<N>
    extends GPULimitFluentImpl<ResourceLimitsFluent.GpusNested<N>>
    implements ResourceLimitsFluent.GpusNested<N>,
    Nested<N> {
        private final GPULimitBuilder builder;
        private final int index;

        GpusNestedImpl(int index, GPULimit item) {
            this.index = index;
            this.builder = new GPULimitBuilder(this, item);
        }

        GpusNestedImpl() {
            this.index = -1;
            this.builder = new GPULimitBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluentImpl.this.setToGpus(this.index, this.builder.build());
        }

        @Override
        public N endGpus() {
            return this.and();
        }
    }

    public class CoresNestedImpl<N>
    extends ResourceRangeFluentImpl<ResourceLimitsFluent.CoresNested<N>>
    implements ResourceLimitsFluent.CoresNested<N>,
    Nested<N> {
        private final ResourceRangeBuilder builder;

        CoresNestedImpl(ResourceRange item) {
            this.builder = new ResourceRangeBuilder(this, item);
        }

        CoresNestedImpl() {
            this.builder = new ResourceRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceLimitsFluentImpl.this.withCores(this.builder.build());
        }

        @Override
        public N endCores() {
            return this.and();
        }
    }
}

