/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_5.TLSProfileSpec;
import io.fabric8.openshift.api.model.v5_5.TLSProfileSpecFluent;
import io.fabric8.openshift.api.model.v5_5.TLSProfileSpecFluentImpl;
import java.util.Objects;

public class TLSProfileSpecBuilder
extends TLSProfileSpecFluentImpl<TLSProfileSpecBuilder>
implements VisitableBuilder<TLSProfileSpec, TLSProfileSpecBuilder> {
    TLSProfileSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TLSProfileSpecBuilder() {
        this(true);
    }

    public TLSProfileSpecBuilder(Boolean validationEnabled) {
        this(new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, TLSProfileSpec instance) {
        this(fluent, instance, true);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, TLSProfileSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCiphers(instance.getCiphers());
        fluent.withMinTLSVersion(instance.getMinTLSVersion());
        this.validationEnabled = validationEnabled;
    }

    public TLSProfileSpecBuilder(TLSProfileSpec instance) {
        this(instance, (Boolean)true);
    }

    public TLSProfileSpecBuilder(TLSProfileSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TLSProfileSpec build() {
        TLSProfileSpec buildable = new TLSProfileSpec(this.fluent.getCiphers(), this.fluent.getMinTLSVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSProfileSpecBuilder that = (TLSProfileSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

