/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_5.OAuth;
import io.fabric8.openshift.api.model.v5_5.OAuthFluent;
import io.fabric8.openshift.api.model.v5_5.OAuthSpec;
import io.fabric8.openshift.api.model.v5_5.OAuthSpecBuilder;
import io.fabric8.openshift.api.model.v5_5.OAuthSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_5.OAuthStatus;
import io.fabric8.openshift.api.model.v5_5.OAuthStatusBuilder;
import io.fabric8.openshift.api.model.v5_5.OAuthStatusFluentImpl;
import java.util.Objects;

public class OAuthFluentImpl<A extends OAuthFluent<A>>
extends BaseFluent<A>
implements OAuthFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OAuthSpecBuilder spec;
    private OAuthStatusBuilder status;

    public OAuthFluentImpl() {
    }

    public OAuthFluentImpl(OAuth instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public OAuthSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public OAuthSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(OAuthSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new OAuthSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public OAuthFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public OAuthFluent.SpecNested<A> withNewSpecLike(OAuthSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public OAuthFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public OAuthFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new OAuthSpecBuilder().build());
    }

    @Override
    public OAuthFluent.SpecNested<A> editOrNewSpecLike(OAuthSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public OAuthStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public OAuthStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(OAuthStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new OAuthStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public OAuthFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public OAuthFluent.StatusNested<A> withNewStatusLike(OAuthStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public OAuthFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public OAuthFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new OAuthStatusBuilder().build());
    }

    @Override
    public OAuthFluent.StatusNested<A> editOrNewStatusLike(OAuthStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthFluentImpl that = (OAuthFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends OAuthStatusFluentImpl<OAuthFluent.StatusNested<N>>
    implements OAuthFluent.StatusNested<N>,
    Nested<N> {
        private final OAuthStatusBuilder builder;

        StatusNestedImpl(OAuthStatus item) {
            this.builder = new OAuthStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new OAuthStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends OAuthSpecFluentImpl<OAuthFluent.SpecNested<N>>
    implements OAuthFluent.SpecNested<N>,
    Nested<N> {
        private final OAuthSpecBuilder builder;

        SpecNestedImpl(OAuthSpec item) {
            this.builder = new OAuthSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new OAuthSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthFluent.MetadataNested<N>>
    implements OAuthFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

