/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_5.ImageSignature;
import io.fabric8.openshift.api.model.v5_5.ImageSignatureFluent;
import io.fabric8.openshift.api.model.v5_5.ImageSignatureFluentImpl;
import java.util.Objects;

public class ImageSignatureBuilder
extends ImageSignatureFluentImpl<ImageSignatureBuilder>
implements VisitableBuilder<ImageSignature, ImageSignatureBuilder> {
    ImageSignatureFluent<?> fluent;
    Boolean validationEnabled;

    public ImageSignatureBuilder() {
        this(true);
    }

    public ImageSignatureBuilder(Boolean validationEnabled) {
        this(new ImageSignature(), validationEnabled);
    }

    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSignature(), validationEnabled);
    }

    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent, ImageSignature instance) {
        this(fluent, instance, true);
    }

    public ImageSignatureBuilder(ImageSignatureFluent<?> fluent, ImageSignature instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConditions(instance.getConditions());
        fluent.withContent(instance.getContent());
        fluent.withCreated(instance.getCreated());
        fluent.withImageIdentity(instance.getImageIdentity());
        fluent.withIssuedBy(instance.getIssuedBy());
        fluent.withIssuedTo(instance.getIssuedTo());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSignedClaims(instance.getSignedClaims());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ImageSignatureBuilder(ImageSignature instance) {
        this(instance, (Boolean)true);
    }

    public ImageSignatureBuilder(ImageSignature instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withContent(instance.getContent());
        this.withCreated(instance.getCreated());
        this.withImageIdentity(instance.getImageIdentity());
        this.withIssuedBy(instance.getIssuedBy());
        this.withIssuedTo(instance.getIssuedTo());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignedClaims(instance.getSignedClaims());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ImageSignature build() {
        ImageSignature buildable = new ImageSignature(this.fluent.getApiVersion(), this.fluent.getConditions(), this.fluent.getContent(), this.fluent.getCreated(), this.fluent.getImageIdentity(), this.fluent.getIssuedBy(), this.fluent.getIssuedTo(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSignedClaims(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSignatureBuilder that = (ImageSignatureBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

