/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.openshift.api.model.v5_5.ExternalIPPolicy;
import io.fabric8.openshift.api.model.v5_5.ExternalIPPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalIPPolicyFluentImpl<A extends ExternalIPPolicyFluent<A>>
extends BaseFluent<A>
implements ExternalIPPolicyFluent<A> {
    private List<String> allowedCIDRs = new ArrayList<String>();
    private List<String> rejectedCIDRs = new ArrayList<String>();

    public ExternalIPPolicyFluentImpl() {
    }

    public ExternalIPPolicyFluentImpl(ExternalIPPolicy instance) {
        this.withAllowedCIDRs(instance.getAllowedCIDRs());
        this.withRejectedCIDRs(instance.getRejectedCIDRs());
    }

    @Override
    public A addToAllowedCIDRs(int index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCIDRs(int index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCIDRs(String ... items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCIDRs(Collection<String> items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCIDRs(String ... items) {
        for (String item : items) {
            if (this.allowedCIDRs == null) continue;
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.allowedCIDRs == null) continue;
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCIDRs() {
        return this.allowedCIDRs;
    }

    @Override
    public String getAllowedCIDR(int index) {
        return this.allowedCIDRs.get(index);
    }

    @Override
    public String getFirstAllowedCIDR() {
        return this.allowedCIDRs.get(0);
    }

    @Override
    public String getLastAllowedCIDR() {
        return this.allowedCIDRs.get(this.allowedCIDRs.size() - 1);
    }

    @Override
    public String getMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedCIDRs(List<String> allowedCIDRs) {
        if (this.allowedCIDRs != null) {
            this._visitables.get("allowedCIDRs").removeAll(this.allowedCIDRs);
        }
        if (allowedCIDRs != null) {
            this.allowedCIDRs = new ArrayList<String>();
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        } else {
            this.allowedCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedCIDRs(String ... allowedCIDRs) {
        if (this.allowedCIDRs != null) {
            this.allowedCIDRs.clear();
        }
        if (allowedCIDRs != null) {
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCIDRs() {
        return this.allowedCIDRs != null && !this.allowedCIDRs.isEmpty();
    }

    @Override
    public A addNewAllowedCIDR(String arg0) {
        return this.addToAllowedCIDRs(new String(arg0));
    }

    @Override
    public A addToRejectedCIDRs(int index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRejectedCIDRs(int index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRejectedCIDRs(String ... items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRejectedCIDRs(Collection<String> items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRejectedCIDRs(String ... items) {
        for (String item : items) {
            if (this.rejectedCIDRs == null) continue;
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRejectedCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.rejectedCIDRs == null) continue;
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRejectedCIDRs() {
        return this.rejectedCIDRs;
    }

    @Override
    public String getRejectedCIDR(int index) {
        return this.rejectedCIDRs.get(index);
    }

    @Override
    public String getFirstRejectedCIDR() {
        return this.rejectedCIDRs.get(0);
    }

    @Override
    public String getLastRejectedCIDR() {
        return this.rejectedCIDRs.get(this.rejectedCIDRs.size() - 1);
    }

    @Override
    public String getMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRejectedCIDRs(List<String> rejectedCIDRs) {
        if (this.rejectedCIDRs != null) {
            this._visitables.get("rejectedCIDRs").removeAll(this.rejectedCIDRs);
        }
        if (rejectedCIDRs != null) {
            this.rejectedCIDRs = new ArrayList<String>();
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        } else {
            this.rejectedCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withRejectedCIDRs(String ... rejectedCIDRs) {
        if (this.rejectedCIDRs != null) {
            this.rejectedCIDRs.clear();
        }
        if (rejectedCIDRs != null) {
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRejectedCIDRs() {
        return this.rejectedCIDRs != null && !this.rejectedCIDRs.isEmpty();
    }

    @Override
    public A addNewRejectedCIDR(String arg0) {
        return this.addToRejectedCIDRs(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIPPolicyFluentImpl that = (ExternalIPPolicyFluentImpl)o;
        if (this.allowedCIDRs != null ? !this.allowedCIDRs.equals(that.allowedCIDRs) : that.allowedCIDRs != null) {
            return false;
        }
        return !(this.rejectedCIDRs != null ? !this.rejectedCIDRs.equals(that.rejectedCIDRs) : that.rejectedCIDRs != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowedCIDRs, this.rejectedCIDRs, super.hashCode());
    }
}

