/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_5.DNS;
import io.fabric8.openshift.api.model.v5_5.DNSFluent;
import io.fabric8.openshift.api.model.v5_5.DNSSpec;
import io.fabric8.openshift.api.model.v5_5.DNSSpecBuilder;
import io.fabric8.openshift.api.model.v5_5.DNSSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_5.DNSStatus;
import io.fabric8.openshift.api.model.v5_5.DNSStatusBuilder;
import io.fabric8.openshift.api.model.v5_5.DNSStatusFluentImpl;
import java.util.Objects;

public class DNSFluentImpl<A extends DNSFluent<A>>
extends BaseFluent<A>
implements DNSFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DNSSpecBuilder spec;
    private DNSStatusBuilder status;

    public DNSFluentImpl() {
    }

    public DNSFluentImpl(DNS instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DNSFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DNSFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DNSFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DNSFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public DNSFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public DNSSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public DNSSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(DNSSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new DNSSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public DNSFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DNSFluent.SpecNested<A> withNewSpecLike(DNSSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DNSFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DNSFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new DNSSpecBuilder().build());
    }

    @Override
    public DNSFluent.SpecNested<A> editOrNewSpecLike(DNSSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public DNSStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public DNSStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(DNSStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new DNSStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public DNSFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DNSFluent.StatusNested<A> withNewStatusLike(DNSStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DNSFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public DNSFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new DNSStatusBuilder().build());
    }

    @Override
    public DNSFluent.StatusNested<A> editOrNewStatusLike(DNSStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSFluentImpl that = (DNSFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends DNSStatusFluentImpl<DNSFluent.StatusNested<N>>
    implements DNSFluent.StatusNested<N>,
    Nested<N> {
        private final DNSStatusBuilder builder;

        StatusNestedImpl(DNSStatus item) {
            this.builder = new DNSStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new DNSStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DNSSpecFluentImpl<DNSFluent.SpecNested<N>>
    implements DNSFluent.SpecNested<N>,
    Nested<N> {
        private final DNSSpecBuilder builder;

        SpecNestedImpl(DNSSpec item) {
            this.builder = new DNSSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DNSSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DNSFluent.MetadataNested<N>>
    implements DNSFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

