/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.utils;

import io.fabric8.kubernetes.api.model.v5_5.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_5.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_5.ListMeta;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMeta;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectUtils {
    public static ObjectMeta objectMetadata(Object obj) throws ReflectiveOperationException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof HasMetadata) {
            return ((HasMetadata)obj).getMetadata();
        }
        try {
            Method mdField = obj.getClass().getMethod("getMetadata", new Class[0]);
            return (ObjectMeta)mdField.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectiveOperationException(e);
        }
    }

    public static String namespace(Object obj) throws ReflectiveOperationException {
        if (obj == null) {
            return "";
        }
        return ReflectUtils.objectMetadata(obj).getNamespace();
    }

    public static ListMeta listMetadata(Object listObj) throws ReflectiveOperationException {
        if (listObj instanceof KubernetesResourceList) {
            return ((KubernetesResourceList)listObj).getMetadata();
        }
        try {
            Method mdField = listObj.getClass().getMethod("getMetadata", new Class[0]);
            return (ListMeta)mdField.invoke(listObj, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectiveOperationException(e);
        }
    }

    public static <ApiType> List<ApiType> getItems(Object listObj) throws ReflectiveOperationException {
        if (listObj instanceof KubernetesResourceList) {
            return ((KubernetesResourceList)listObj).getItems();
        }
        try {
            Method getItemsMethod = listObj.getClass().getMethod("getItems", new Class[0]);
            return (List)getItemsMethod.invoke(listObj, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectiveOperationException(e);
        }
    }
}

