/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamPumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamPumper.class);

    private InputStreamPumper() {
    }

    public static InputStream asInterruptible(final InputStream is) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                while (!Thread.currentThread().isInterrupted()) {
                    if (is.available() > 0) {
                        return is.read(b, off, len);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(e);
                    }
                }
                throw new IOException();
            }
        };
    }

    public static void transferTo(InputStream in, Writable out) throws IOException {
        int length;
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, length);
        }
    }

    public static CompletableFuture<?> pump(InputStream in, Writable out, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            try {
                InputStreamPumper.transferTo(in, out);
            }
            catch (Exception e) {
                if (!Thread.currentThread().isInterrupted()) {
                    LOGGER.error("Error while pumping stream.", (Throwable)e);
                }
                LOGGER.debug("Interrupted while pumping stream.");
            }
        }, executor);
    }

    public static interface Writable {
        public void write(byte[] var1, int var2, int var3) throws IOException;
    }
}

