/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.informers.cache;

import io.fabric8.kubernetes.clnt.v5_5.informers.ResourceEventHandler;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private long resyncPeriodInMillis;
    private ZonedDateTime nextResync;
    private ResourceEventHandler<T> handler;

    public ProcessorListener(ResourceEventHandler<T> handler, long resyncPeriodInMillis) {
        this.resyncPeriodInMillis = resyncPeriodInMillis;
        this.handler = handler;
        this.determineNextResync(ZonedDateTime.now());
    }

    public void add(Notification<T> notification) {
        try {
            notification.handle(this.handler);
        }
        catch (Exception ex) {
            log.error("Failed invoking {} event handler: {}", new Object[]{this.handler, ex.getMessage(), ex});
        }
    }

    public void determineNextResync(ZonedDateTime now) {
        this.nextResync = now.plus(this.resyncPeriodInMillis, ChronoUnit.MILLIS);
    }

    public boolean shouldResync(ZonedDateTime now) {
        return this.resyncPeriodInMillis != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public static final class DeleteNotification<T>
    extends Notification<T> {
        private boolean unknownFinalState;

        public DeleteNotification(T oldObject) {
            this(oldObject, false);
        }

        public DeleteNotification(T oldObject, boolean unknownFinalState) {
            super(oldObject, null);
            this.unknownFinalState = unknownFinalState;
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            resourceEventHandler.onDelete(this.getOldObject(), this.unknownFinalState);
        }
    }

    public static final class AddNotification<T>
    extends Notification<T> {
        public AddNotification(T newObject) {
            super(null, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            resourceEventHandler.onAdd(this.getNewObject());
        }
    }

    public static final class UpdateNotification<T>
    extends Notification<T> {
        public UpdateNotification(T oldObject, T newObject) {
            super(oldObject, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<T> resourceEventHandler) {
            resourceEventHandler.onUpdate(this.getOldObject(), this.getNewObject());
        }
    }

    public static abstract class Notification<T> {
        private final T oldObject;
        private final T newObject;

        public Notification(T oldObject, T newObject) {
            this.oldObject = oldObject;
            this.newObject = newObject;
        }

        public T getOldObject() {
            return this.oldObject;
        }

        public T getNewObject() {
            return this.newObject;
        }

        public abstract void handle(ResourceEventHandler<T> var1);
    }
}

