/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.api.model.v5_5.Namespace;
import io.fabric8.kubernetes.api.model.v5_5.NamespaceBuilder;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.core.v1.NamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NamespaceHandler
implements ResourceHandler<Namespace, NamespaceBuilder> {
    @Override
    public String getKind() {
        return Namespace.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Namespace create(OkHttpClient client, Config config, String namespace, Namespace item, boolean dryRun) {
        return (Namespace)((WritableOperation)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Namespace[0]);
    }

    @Override
    public Namespace replace(OkHttpClient client, Config config, String namespace, Namespace item, boolean dryRun) {
        return ((WritableOperation)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Namespace reload(OkHttpClient client, Config config, String namespace, Namespace item) {
        return (Namespace)((Gettable)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NamespaceBuilder edit(Namespace item) {
        return new NamespaceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Namespace item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new NamespaceOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, Watcher<Namespace> watcher) {
        return ((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, String resourceVersion, Watcher<Namespace> watcher) {
        return ((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Namespace item, ListOptions options, Watcher<Namespace> watcher) {
        return ((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Namespace waitUntilReady(OkHttpClient client, Config config, String namespace, Namespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Namespace waitUntilCondition(OkHttpClient client, Config config, String namespace, Namespace item, Predicate<Namespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Namespace)((Resource)new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

