/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_5.APIService;
import io.fabric8.kubernetes.api.model.v5_5.APIServiceBuilder;
import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.core.v1.APIServiceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class APIServiceHandler
implements ResourceHandler<APIService, APIServiceBuilder> {
    @Override
    public String getKind() {
        return APIService.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apiregistration.k8s.io/v1";
    }

    @Override
    public APIService create(OkHttpClient client, Config config, String namespace, APIService item, boolean dryRun) {
        return (APIService)((WritableOperation)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new APIService[0]);
    }

    @Override
    public APIService replace(OkHttpClient client, Config config, String namespace, APIService item, boolean dryRun) {
        return ((WritableOperation)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public APIService reload(OkHttpClient client, Config config, String namespace, APIService item) {
        return (APIService)((Gettable)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public APIServiceBuilder edit(APIService item) {
        return new APIServiceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, APIService item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new APIServiceOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, String resourceVersion, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, ListOptions options, Watcher<APIService> watcher) {
        return ((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public APIService waitUntilReady(OkHttpClient client, Config config, String namespace, APIService item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIService)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public APIService waitUntilCondition(OkHttpClient client, Config config, String namespace, APIService item, Predicate<APIService> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIService)((Resource)new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

