/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.handlers;

import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_5.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_5.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.Handlers;
import io.fabric8.kubernetes.clnt.v5_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.KubernetesListOperationsImpl;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class KubernetesListHandler
implements ResourceHandler<KubernetesList, KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesListHandler.class);
    private static final String KIND = new KubernetesList().getKind();

    @Override
    public String getKind() {
        return KIND;
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public KubernetesList create(OkHttpClient client, Config config, String namespace, KubernetesList item, boolean dryRun) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, HasMetadataOperation.DEFAULT_PROPAGATION_POLICY, -1L, false, false, item, null, dryRun).create(new KubernetesList[0]);
    }

    @Override
    public KubernetesList replace(OkHttpClient client, Config config, String namespace, KubernetesList item, boolean dryRun) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind(), item.getApiVersion());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.replace(client, config, namespace, metadata, dryRun));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesList reload(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind(), item.getApiVersion());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.reload(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesListBuilder edit(KubernetesList item) {
        return new KubernetesListBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, KubernetesList item, boolean dryRun) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, propagationPolicy, gracePeriodSeconds, false, false, item, null, dryRun).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, String resourceVersion, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, ListOptions listOptions, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public KubernetesList waitUntilReady(OkHttpClient client, Config config, String namespace, KubernetesList item, long amount, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public KubernetesList waitUntilCondition(OkHttpClient client, Config config, String namespace, KubernetesList item, Predicate<KubernetesList> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }
}

