/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_5.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_5.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.BaseOperationRequestBuilder;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.WatchConnectionManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchHTTPManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchHTTPManager.class);
    private Call call;

    public WatchHTTPManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long connectTimeout) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, connectTimeout, 5);
    }

    public WatchHTTPManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long connectTimeout, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, new BaseOperationRequestBuilder<T, L>(baseOperation, listOptions), () -> {
            OkHttpClient clonedClient = client.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).cache(null).build();
            for (Interceptor i : clonedClient.networkInterceptors()) {
                if (!(i instanceof HttpLoggingInterceptor)) continue;
                HttpLoggingInterceptor interceptor = (HttpLoggingInterceptor)i;
                interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            }
            return clonedClient;
        });
    }

    @Override
    protected synchronized void run(Request request) {
        this.call = this.client.newCall(request);
        this.call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                logger.info("Watch connection failed. reason: {}", (Object)e.getMessage());
                WatchHTTPManager.this.scheduleReconnect();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    WatchHTTPManager.this.resetReconnectAttempts();
                    if (!response.isSuccessful() && WatchHTTPManager.this.onStatus(OperationSupport.createStatus(response.code(), response.message()))) {
                        return;
                    }
                    BufferedSource source = response.body().source();
                    while (!source.exhausted()) {
                        String message = source.readUtf8LineStrict();
                        WatchHTTPManager.this.onMessage(message);
                    }
                }
                catch (Exception e) {
                    logger.info("Watch terminated unexpectedly. reason: {}", (Object)e.getMessage());
                }
                finally {
                    WatchConnectionManager.closeBody(response);
                }
                WatchHTTPManager.this.scheduleReconnect();
            }
        });
    }

    @Override
    protected synchronized void closeRequest() {
        if (this.call != null) {
            this.call.cancel();
            this.call = null;
        }
    }
}

