/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_5.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_5.utils.InputStreamPumper;
import io.fabric8.kubernetes.clnt.v5_5.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchCallback
implements LogWatch,
Callback,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchCallback.class);
    private final Config config;
    private final OutputStream out;
    private final PipedInputStream output;
    private final Set<Closeable> toClose = new LinkedHashSet<Closeable>();
    private final CompletableFuture<Void> startedFuture = new CompletableFuture();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @Deprecated
    public LogWatchCallback(OutputStream out) {
        this(new Config(), out);
    }

    public LogWatchCallback(Config config, OutputStream out) {
        this.config = config;
        if (out == null) {
            this.out = new PipedOutputStream();
            this.output = new PipedInputStream();
            this.toClose.add(this.out);
            this.toClose.add(this.output);
        } else {
            this.out = out;
            this.output = null;
        }
        if (this.out instanceof PipedOutputStream && this.output != null) {
            try {
                this.output.connect((PipedOutputStream)this.out);
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.executorService.shutdownNow();
        Utils.closeQuietly(this.toClose);
    }

    public void waitUntilReady() {
        if (!Utils.waitUntilReady(this.startedFuture, this.config.getRequestTimeout(), TimeUnit.MILLISECONDS) && LOGGER.isDebugEnabled()) {
            LOGGER.warn("Log watch request has not been opened within: " + this.config.getRequestTimeout() + " millis.");
        }
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    public void onFailure(Call call, IOException ioe) {
        if (this.closed.get()) {
            return;
        }
        LOGGER.error("Log Callback Failure.", (Throwable)ioe);
        this.cleanUp();
        this.startedFuture.completeExceptionally(ioe);
    }

    public void onResponse(Call call, Response response) throws IOException {
        if (!this.executorService.isShutdown()) {
            InputStreamPumper.pump(response.body().byteStream(), this.out::write, this.executorService).whenComplete((o, t) -> {
                this.cleanUp();
                response.close();
            });
            this.startedFuture.complete(null);
        }
    }
}

