/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5.dsl.base;

import io.fabric8.kubernetes.api.builder.v5_5.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_5.Visitor;
import io.fabric8.kubernetes.api.model.v5_5.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_5.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_5.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_5.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_5.ListOptions;
import io.fabric8.kubernetes.api.model.v5_5.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.v5_5.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_5.RootPaths;
import io.fabric8.kubernetes.api.model.v5_5.Status;
import io.fabric8.kubernetes.api.model.v5_5.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v5_5.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_5.Config;
import io.fabric8.kubernetes.clnt.v5_5.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_5.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_5.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v5_5.OperationInfo;
import io.fabric8.kubernetes.clnt.v5_5.ResourceNotFoundException;
import io.fabric8.kubernetes.clnt.v5_5.Watch;
import io.fabric8.kubernetes.clnt.v5_5.Watcher;
import io.fabric8.kubernetes.clnt.v5_5.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.FilterNested;
import io.fabric8.kubernetes.clnt.v5_5.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Informable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Replaceable;
import io.fabric8.kubernetes.clnt.v5_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_5.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.FilterNestedImpl;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_5.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.DefaultOperationInfo;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.clnt.v5_5.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.clnt.v5_5.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v5_5.informers.ResourceEventHandler;
import io.fabric8.kubernetes.clnt.v5_5.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_5.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_5.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_5.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.clnt.v5_5.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v5_5.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_5.utils.Utils;
import io.fabric8.kubernetes.clnt.v5_5.utils.WatcherToggle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends OperationSupport
implements OperationInfo,
MixedOperation<T, L, R>,
Resource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseOperation.class);
    private static final String READ_ONLY_UPDATE_EXCEPTION_MESSAGE = "Cannot update read-only resources";
    private static final String READ_ONLY_EDIT_EXCEPTION_MESSAGE = "Cannot edit read-only resources";
    private final boolean cascading;
    private final T item;
    private final String resourceVersion;
    private final boolean reloadingFromServer;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    protected String apiVersion;
    protected Class<T> type;
    protected Class<L> listType;
    private Map<String, Function<T, List<String>>> indexers;

    protected BaseOperation(OperationContext ctx) {
        super(ctx);
        this.cascading = ctx.getCascading();
        this.item = (HasMetadata)ctx.getItem();
        this.reloadingFromServer = ctx.isReloadingFromServer();
        this.resourceVersion = ctx.getResourceVersion();
        this.gracePeriodSeconds = ctx.getGracePeriodSeconds();
        this.propagationPolicy = ctx.getPropagationPolicy();
    }

    public BaseOperation<T, L, R> newInstance(OperationContext context) {
        return new BaseOperation<T, L, R>(context);
    }

    private L listRequestHelper(URL url) {
        try {
            HttpUrl.Builder requestUrlBuilder = HttpUrl.get((URL)url).newBuilder();
            this.addQueryStringParam(requestUrlBuilder, "labelSelector", this.getLabelQueryParam());
            this.addQueryStringParam(requestUrlBuilder, "fieldSelector", this.getFieldQueryParam());
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrlBuilder.build());
            KubernetesResourceList answer = (KubernetesResourceList)this.handleResponse(requestBuilder, this.listType);
            this.updateApiVersion(answer);
            return (L)answer;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    protected URL fetchListUrl(URL url, ListOptions listOptions) throws MalformedURLException {
        return new URL(HttpClientUtils.appendListOptionParams(HttpUrl.get((String)url.toString()).newBuilder(), listOptions).toString());
    }

    private void addQueryStringParam(HttpUrl.Builder requestUrlBuilder, String name, String value) {
        if (Utils.isNotNullOrEmpty(value)) {
            requestUrlBuilder.addQueryParameter(name, value);
        }
    }

    @Override
    public T get() {
        try {
            T answer = this.getMandatory();
            this.updateApiVersion((HasMetadata)answer);
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public T require() {
        try {
            T answer = this.getMandatory();
            if (answer == null) {
                throw new ResourceNotFoundException("The resource you request doesn't exist or couldn't be fetched.");
            }
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            throw new ResourceNotFoundException("Resource not found : " + e.getMessage(), e);
        }
    }

    public T getMandatory() {
        if (this.item != null && !this.reloadingFromServer) {
            return this.item;
        }
        try {
            URL requestUrl = this.getCompleteResourceUrl();
            return this.handleGet(requestUrl);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)e);
        }
    }

    public RootPaths getRootPaths() {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            Request.Builder req = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(req, RootPaths.class);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public T editStatus(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public T edit(Visitor ... visitors) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public <V> T edit(final Class<V> visitorType, final Visitor<V> visitor) {
        return (T)this.edit(new Visitor[]{new TypedVisitor<V>(){

            @Override
            public Class<V> getType() {
                return visitorType;
            }

            @Override
            public void visit(V item) {
                visitor.visit(item);
            }
        }});
    }

    @Override
    public T accept(Consumer<T> consumer) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return (R)this.newInstance(this.context.withName(name));
    }

    @Override
    public Replaceable<T> lockResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inNamespace(String namespace) {
        return this.newInstance(this.context.withNamespace(namespace));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inAnyNamespace() {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build();
        return this.newInstance(this.context.withConfig(updated).withNamespace(null));
    }

    @Override
    public EditReplacePatchDeletable<T> cascading(boolean cascading) {
        return this.newInstance(this.context.withCascading(cascading).withPropagationPolicy(null));
    }

    @Override
    public R load(InputStream is) {
        return (R)this.newInstance(this.context.withItem(BaseOperation.unmarshal(is, this.type)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public R load(String path) {
        return (R)this.load(new File(path));
    }

    @Override
    public Gettable<T> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true));
    }

    @Override
    @SafeVarargs
    public final T create(T ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (T)this.withItem(resources[0]).create(new HasMetadata[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    public T create(T resource) {
        try {
            if (resource != null) {
                return this.handleCreate(resource);
            }
            throw new IllegalArgumentException("Nothing to create.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    @SafeVarargs
    public final T createOrReplace(T ... items) {
        T itemToCreateOrReplace = this.getItem();
        if (items.length > 1) {
            throw new IllegalArgumentException("Too many items to create.");
        }
        if (items.length == 1) {
            itemToCreateOrReplace = items[0];
        }
        if (itemToCreateOrReplace == null) {
            throw new IllegalArgumentException("Nothing to create.");
        }
        if (Utils.isNullOrEmpty(this.name)) {
            return (T)this.withName(itemToCreateOrReplace.getMetadata().getName()).createOrReplace(itemToCreateOrReplace);
        }
        T finalItemToCreateOrReplace = itemToCreateOrReplace;
        CreateOrReplaceHelper<T> createOrReplaceHelper = new CreateOrReplaceHelper<T>(this::create, this::replace, m -> this.waitUntilCondition(Objects::nonNull, 1L, TimeUnit.SECONDS), m -> (HasMetadata)this.fromServer().get());
        return createOrReplaceHelper.createOrReplace(finalItemToCreateOrReplace);
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabels(labels)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelSelector(LabelSelector selector) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelSelector(selector)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabels(labels)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelIn(key, values)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelNotIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelNotIn(key, values)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabel(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabel(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withFields(fields)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withField(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference != null) {
            return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withInvolvedObject(objectReference)).endFilter();
        }
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withNewFilter() {
        return new FilterNestedImpl(this);
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutFields(fields)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutField(key, value)).endFilter();
    }

    public String getLabelQueryParam() {
        Map<String, String[]> labelsNotIn;
        Map<String, String[]> labelsIn;
        Map<String, String[]> labelsNot;
        StringBuilder sb = new StringBuilder();
        Map<String, String> labels = this.context.getLabels();
        if (labels != null && !labels.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = labels.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((entry = iter.next()).getValue() != null) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                sb.append(entry.getKey());
            }
        }
        if ((labelsNot = this.context.getLabelsNot()) != null && !labelsNot.isEmpty()) {
            Iterator<Map.Entry<String, String[]>> iter = labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String[]> entry;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (Utils.isNotNull((Object[])(entry = iter.next()).getValue())) {
                    for (int i = 0; i < entry.getValue().length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(entry.getKey()).append("!=").append(entry.getValue()[i]);
                    }
                    continue;
                }
                sb.append('!').append(entry.getKey());
            }
        }
        if ((labelsIn = this.context.getLabelsIn()) != null && !labelsIn.isEmpty()) {
            Iterator<Map.Entry<String, String[]>> iter = labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                Map.Entry<String, String[]> entry = iter.next();
                sb.append(entry.getKey()).append(" in ").append("(").append(Utils.join(entry.getValue())).append(")");
            }
        }
        if ((labelsNotIn = this.context.getLabelsNotIn()) != null && !labelsNotIn.isEmpty()) {
            Iterator<Map.Entry<String, String[]>> iter = labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                Map.Entry<String, String[]> entry = iter.next();
                sb.append(entry.getKey()).append(" notin ").append("(").append(Utils.join(entry.getValue())).append(")");
            }
        }
        return sb.toString();
    }

    public String getFieldQueryParam() {
        Map<String, String[]> fieldsNot;
        StringBuilder sb = new StringBuilder();
        Map<String, String> fields = this.context.getFields();
        if (fields != null && !fields.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = fields.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                Map.Entry<String, String> entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if ((fieldsNot = this.context.getFieldsNot()) != null && !fieldsNot.isEmpty()) {
            Iterator<Map.Entry<String, String[]>> iter = fieldsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                Map.Entry<String, String[]> entry = iter.next();
                for (int i = 0; i < entry.getValue().length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(entry.getKey()).append("!=").append(entry.getValue()[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public L list() {
        try {
            return this.listRequestHelper(this.getResourceUrl(this.namespace, this.name));
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public L list(Integer limitVal, String continueVal) {
        return (L)this.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.parseLong(limitVal.toString()))).withContinue(continueVal)).build());
    }

    @Override
    public L list(ListOptions listOptions) {
        try {
            return this.listRequestHelper(this.fetchListUrl(this.getNamespacedUrl(), listOptions));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public Boolean delete() {
        if (this.item != null || this.name != null && !this.name.isEmpty()) {
            try {
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    @Override
    @SafeVarargs
    public final Boolean delete(T ... items) {
        return this.delete(Arrays.asList(items));
    }

    @Override
    public Boolean delete(List<T> items) {
        boolean deleted = true;
        if (items != null) {
            for (HasMetadata toDelete : items) {
                if (toDelete == null) continue;
                this.updateApiVersion(toDelete);
                try {
                    if (toDelete.getMetadata() != null && toDelete.getMetadata().getName() != null && !toDelete.getMetadata().getName().isEmpty()) {
                        deleted &= ((Resource)this.inNamespace(this.checkNamespace(toDelete)).withName(toDelete.getMetadata().getName())).delete().booleanValue();
                        continue;
                    }
                    deleted &= this.withItem(toDelete).delete().booleanValue();
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 404) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        return deleted;
    }

    @Override
    public T updateStatus(T item) {
        try {
            return this.handleUpdate(item, true);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)e);
        }
    }

    @Override
    public T patchStatus(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public BaseOperation<T, L, R> withItem(T item) {
        return this.newInstance(this.context.withItem(item));
    }

    void deleteThis() {
        try {
            if (this.item != null) {
                this.updateApiVersion((HasMetadata)this.item);
                this.handleDelete(this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
            } else {
                this.handleDelete(this.getResourceURLForWriteOperation(this.getResourceUrl()), this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("delete"), (Throwable)e);
        }
    }

    void deleteList() {
        this.delete(this.list().getItems());
    }

    @Override
    public R withResourceVersion(String resourceVersion) {
        return (R)this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public Watch watch(Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(this.resourceVersion)).build(), watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<T> watcher) {
        WatcherToggle<T> watcherToggle = new WatcherToggle<T>(watcher, true);
        options.setWatch(Boolean.TRUE);
        WatchConnectionManager watch = null;
        try {
            watch = new WatchConnectionManager(this.client, this, options, watcherToggle, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getWebsocketTimeout());
            watch.waitUntilReady();
            return watch;
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
        }
        catch (KubernetesClientException ke) {
            List<Integer> furtherProcessedCodes = Arrays.asList(200, 503);
            if (!furtherProcessedCodes.contains(ke.getCode())) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            try {
                return new WatchHTTPManager(this.client, this, options, watcher, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getConnectionTimeout());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
            }
        }
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T replaceStatus(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T patch(PatchContext patchContext, String patch) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public boolean isResourceNamespaced() {
        return Utils.isResourceNamespaced(this.getType());
    }

    protected T handleResponse(Request.Builder requestBuilder) throws ExecutionException, InterruptedException, IOException {
        return (T)((HasMetadata)this.handleResponse(requestBuilder, this.getType()));
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)resource);
        return (T)((HasMetadata)this.handleCreate(resource, this.getType()));
    }

    protected T handleUpdate(T updated, boolean status) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handleUpdate(updated, this.getType(), status));
    }

    protected T handlePatch(PatchContext context, T current, T updated, boolean status) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handlePatch(context, current, updated, this.getType(), status));
    }

    protected T handlePatch(T current, Map<String, Object> patchedUpdate) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)current);
        return (T)((HasMetadata)this.handlePatch(current, patchedUpdate, this.getType()));
    }

    protected T sendPatchedObject(T oldObject, T updatedObject) {
        try {
            return this.handlePatch(null, oldObject, updatedObject, false);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected Scale handleScale(Scale scaleParam) {
        try {
            return this.handleScale(this.getCompleteResourceUrl().toString(), scaleParam);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)e);
        }
    }

    protected Status handleDeploymentRollback(DeploymentRollback deploymentRollback) {
        try {
            return this.handleDeploymentRollback(this.getCompleteResourceUrl().toString(), deploymentRollback);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)e);
        }
    }

    protected T handleGet(URL resourceUrl) throws InterruptedException, ExecutionException, IOException {
        HasMetadata answer = (HasMetadata)this.handleGet(resourceUrl, this.getType());
        this.updateApiVersion(answer);
        return (T)answer;
    }

    private URL getCompleteResourceUrl() throws MalformedURLException {
        URL requestUrl = null;
        requestUrl = this.item != null ? this.getNamespacedUrl(this.item) : this.getNamespacedUrl();
        if (this.name != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.name));
        } else if (this.item != null && this.reloadingFromServer) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.checkName(this.item)));
        }
        return requestUrl;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    @Override
    public String getKind() {
        return this.type != null ? this.type.getSimpleName() : "Resource";
    }

    @Override
    public String getOperationType() {
        return null;
    }

    @Override
    public OperationInfo forOperationType(String type) {
        return new DefaultOperationInfo(this.getKind(), type, this.name, this.namespace);
    }

    @Override
    public FilterWatchListDeletable<T, L> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    @Override
    public EditReplacePatchDeletable<T> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    public BaseOperation<T, L, R> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        return this.newInstance(this.context.withWatchRetryInitialBackoffMillis(backoffUnit.toMillis(initialBackoff)).withWatchRetryBackoffMultiplier(backoffMultiplier));
    }

    protected Class<? extends Config> getConfigType() {
        return Config.class;
    }

    protected void updateApiVersion(KubernetesResourceList<T> list) {
        String version = this.getApiVersion();
        if (list != null && version != null && version.length() > 0 && list.getItems() != null) {
            list.getItems().forEach(this::updateApiVersion);
        }
    }

    protected void updateApiVersion(HasMetadata hasMetadata) {
        String current;
        String version = this.getApiVersion();
        if (hasMetadata != null && version != null && version.length() > 0 && ((current = hasMetadata.getApiVersion()) == null || "v1".equals(current) || current.indexOf(47) < 0 && version.indexOf(47) > 0)) {
            hasMetadata.setApiVersion(version);
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isApiGroup() {
        return this.apiVersion != null && this.apiVersion.indexOf(47) > 0;
    }

    public Readiness getReadiness() {
        return Readiness.getInstance();
    }

    @Override
    public final Boolean isReady() {
        return this.getReadiness().isReady((HasMetadata)this.get());
    }

    @Override
    public T waitUntilReady(long amount, TimeUnit timeUnit) {
        return (T)this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T waitUntilCondition(Predicate<T> condition, long amount, TimeUnit timeUnit) {
        CompletableFuture future = new CompletableFuture();
        final Consumer<HasMetadata> tester = obj -> {
            try {
                if (condition.test(obj)) {
                    future.complete(obj);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        try (DefaultSharedIndexInformer informer = this.createInformer(0L, l -> {
            if (l.getItems().isEmpty()) {
                tester.accept(null);
            }
        }, new ResourceEventHandler<T>(){

            @Override
            public void onAdd(T obj) {
                tester.accept(obj);
            }

            @Override
            public void onUpdate(T oldObj, T newObj) {
                tester.accept(newObj);
            }

            @Override
            public void onDelete(T obj, boolean deletedFinalStateUnknown) {
                tester.accept(null);
            }
        });){
            future.whenComplete((r, t) -> informer.stop());
            informer.run();
            HasMetadata hasMetadata = (HasMetadata)future.get(amount, timeUnit);
            return (T)hasMetadata;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(e.getCause());
        }
        catch (ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e.getCause());
        }
        catch (TimeoutException e) {
            T i = this.getItem();
            if (i == null) throw new KubernetesClientTimeoutException(this.getKind(), this.getName(), this.getNamespace(), amount, timeUnit);
            throw new KubernetesClientTimeoutException((HasMetadata)i, amount, timeUnit);
        }
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setListType(Class<L> listType) {
        this.listType = listType;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public WritableOperation<T> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun));
    }

    @Override
    public Informable<T> withIndexers(Map<String, Function<T, List<String>>> indexers) {
        BaseOperation<T, L, R> result = this.newInstance(this.context);
        result.indexers = indexers;
        return result;
    }

    @Override
    public SharedIndexInformer<T> inform(ResourceEventHandler<T> handler, long resync) {
        DefaultSharedIndexInformer<T, L> result = this.createInformer(resync, null, handler);
        result.run();
        return result;
    }

    private DefaultSharedIndexInformer<T, L> createInformer(long resync, final Consumer<L> onList, ResourceEventHandler<T> handler) {
        T i = this.getItem();
        final String name = Utils.isNotNullOrEmpty(this.getName()) || i != null ? this.checkName(i) : null;
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(this.getType(), new ListerWatcher<T, L>(){

            @Override
            public L list(ListOptions params, String namespace, OperationContext context) {
                if (name != null) {
                    params.setFieldSelector("metadata.name=" + name);
                }
                Object result = BaseOperation.this.list(params);
                if (onList != null) {
                    onList.accept(result);
                }
                return result;
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> watcher) {
                return BaseOperation.this.watch(params, watcher);
            }
        }, resync, this.context, Runnable::run);
        if (this.indexers != null) {
            informer.addIndexers(this.indexers);
        }
        if (handler != null) {
            informer.addEventHandler(handler);
        }
        return informer;
    }
}

