/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_5;

import io.fabric8.kubernetes.api.model.v5_5.Service;
import io.fabric8.kubernetes.api.model.v5_5.ServicePort;
import io.fabric8.kubernetes.clnt.v5_5.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_5.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v5_5.utils.URLFromServiceUtil;

public class URLFromClusterIPImpl
implements ServiceToURLProvider {
    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIFTH.getValue();
    }

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        if (port != null && service.getSpec().getType().equals("ClusterIP")) {
            return port.getProtocol().toLowerCase() + "://" + service.getSpec().getClusterIP() + ":" + port.getPort();
        }
        return null;
    }
}

