/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5.storage;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_5.storage.TokenRequest;
import io.fabric8.kubernetes.api.model.v5_5.storage.TokenRequestFluent;
import io.fabric8.kubernetes.api.model.v5_5.storage.TokenRequestFluentImpl;
import java.util.Objects;

public class TokenRequestBuilder
extends TokenRequestFluentImpl<TokenRequestBuilder>
implements VisitableBuilder<TokenRequest, TokenRequestBuilder> {
    TokenRequestFluent<?> fluent;
    Boolean validationEnabled;

    public TokenRequestBuilder() {
        this(true);
    }

    public TokenRequestBuilder(Boolean validationEnabled) {
        this(new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenRequest(), validationEnabled);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent, TokenRequest instance) {
        this(fluent, instance, true);
    }

    public TokenRequestBuilder(TokenRequestFluent<?> fluent, TokenRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAudience(instance.getAudience());
        fluent.withExpirationSeconds(instance.getExpirationSeconds());
        this.validationEnabled = validationEnabled;
    }

    public TokenRequestBuilder(TokenRequest instance) {
        this(instance, (Boolean)true);
    }

    public TokenRequestBuilder(TokenRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAudience(instance.getAudience());
        this.withExpirationSeconds(instance.getExpirationSeconds());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TokenRequest build() {
        TokenRequest buildable = new TokenRequest(this.fluent.getAudience(), this.fluent.getExpirationSeconds());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenRequestBuilder that = (TokenRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

