/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5.extensions;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_5.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.v5_5.extensions.IngressTLSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressTLSFluentImpl<A extends IngressTLSFluent<A>>
extends BaseFluent<A>
implements IngressTLSFluent<A> {
    private List<String> hosts = new ArrayList<String>();
    private String secretName;

    public IngressTLSFluentImpl() {
    }

    public IngressTLSFluentImpl(IngressTLS instance) {
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get("hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg0) {
        return this.addToHosts(new String(arg0));
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    @Deprecated
    public A withNewSecretName(String arg0) {
        return this.withSecretName(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressTLSFluentImpl that = (IngressTLSFluentImpl)o;
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.secretName, super.hashCode());
    }
}

