/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1.CertificateSigningRequestCondition;
import io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1.CertificateSigningRequestConditionBuilder;
import io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1.CertificateSigningRequestConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1.CertificateSigningRequestStatus;
import io.fabric8.kubernetes.api.model.v5_5.certificates.v1beta1.CertificateSigningRequestStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateSigningRequestStatusFluentImpl<A extends CertificateSigningRequestStatusFluent<A>>
extends BaseFluent<A>
implements CertificateSigningRequestStatusFluent<A> {
    private String certificate;
    private List<CertificateSigningRequestConditionBuilder> conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();

    public CertificateSigningRequestStatusFluentImpl() {
    }

    public CertificateSigningRequestStatusFluentImpl(CertificateSigningRequestStatus instance) {
        this.withCertificate(instance.getCertificate());
        this.withConditions(instance.getConditions());
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public A withCertificate(String certificate) {
        this.certificate = certificate;
        return (A)this;
    }

    @Override
    public Boolean hasCertificate() {
        return this.certificate != null;
    }

    @Override
    @Deprecated
    public A withNewCertificate(String arg0) {
        return this.withCertificate(new String(arg0));
    }

    @Override
    public A addToConditions(int index, CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
        }
        CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
        }
        CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(CertificateSigningRequestCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
        }
        for (CertificateSigningRequestCondition item : items) {
            CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
        }
        for (CertificateSigningRequestCondition item : items) {
            CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(CertificateSigningRequestCondition ... items) {
        for (CertificateSigningRequestCondition item : items) {
            CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<CertificateSigningRequestCondition> items) {
        for (CertificateSigningRequestCondition item : items) {
            CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<CertificateSigningRequestConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            CertificateSigningRequestConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertificateSigningRequestCondition> getConditions() {
        return CertificateSigningRequestStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<CertificateSigningRequestCondition> buildConditions() {
        return CertificateSigningRequestStatusFluentImpl.build(this.conditions);
    }

    @Override
    public CertificateSigningRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public CertificateSigningRequestCondition buildMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
        for (CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
        for (CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
            for (CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(CertificateSigningRequestCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(int index, CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateSigningRequestStatusFluentImpl that = (CertificateSigningRequestStatusFluentImpl)o;
        if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) {
            return false;
        }
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.conditions, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends CertificateSigningRequestConditionFluentImpl<CertificateSigningRequestStatusFluent.ConditionsNested<N>>
    implements CertificateSigningRequestStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final CertificateSigningRequestConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, CertificateSigningRequestCondition item) {
            this.index = index;
            this.builder = new CertificateSigningRequestConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new CertificateSigningRequestConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateSigningRequestStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

