/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_5.authorization.v1beta1.ResourceRule;
import io.fabric8.kubernetes.api.model.v5_5.authorization.v1beta1.ResourceRuleFluent;
import io.fabric8.kubernetes.api.model.v5_5.authorization.v1beta1.ResourceRuleFluentImpl;
import java.util.Objects;

public class ResourceRuleBuilder
extends ResourceRuleFluentImpl<ResourceRuleBuilder>
implements VisitableBuilder<ResourceRule, ResourceRuleBuilder> {
    ResourceRuleFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRuleBuilder() {
        this(true);
    }

    public ResourceRuleBuilder(Boolean validationEnabled) {
        this(new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance) {
        this(fluent, instance, true);
    }

    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent, ResourceRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRuleBuilder(ResourceRule instance) {
        this(instance, (Boolean)true);
    }

    public ResourceRuleBuilder(ResourceRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceRule build() {
        ResourceRule buildable = new ResourceRule(this.fluent.getApiGroups(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRuleBuilder that = (ResourceRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

