/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.IntOrString;
import io.fabric8.kubernetes.api.model.v5_5.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.v5_5.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.v5_5.ServicePort;
import io.fabric8.kubernetes.api.model.v5_5.ServicePortFluent;
import java.util.Objects;

public class ServicePortFluentImpl<A extends ServicePortFluent<A>>
extends BaseFluent<A>
implements ServicePortFluent<A> {
    private String appProtocol;
    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private IntOrStringBuilder targetPort;

    public ServicePortFluentImpl() {
    }

    public ServicePortFluentImpl(ServicePort instance) {
        this.withAppProtocol(instance.getAppProtocol());
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
    }

    @Override
    public String getAppProtocol() {
        return this.appProtocol;
    }

    @Override
    public A withAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return (A)this;
    }

    @Override
    public Boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    @Override
    @Deprecated
    public A withNewAppProtocol(String arg0) {
        return this.withAppProtocol(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Integer getNodePort() {
        return this.nodePort;
    }

    @Override
    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    @Override
    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    @Override
    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    @Override
    @Deprecated
    public A withNewProtocol(String arg0) {
        return this.withProtocol(new String(arg0));
    }

    @Override
    @Deprecated
    public IntOrString getTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public IntOrString buildTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public A withTargetPort(IntOrString targetPort) {
        this._visitables.get("targetPort").remove(this.targetPort);
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.get("targetPort").add(this.targetPort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    @Override
    public A withNewTargetPort(Integer intVal) {
        return this.withTargetPort(new IntOrString(intVal));
    }

    @Override
    public A withNewTargetPort(String strVal) {
        return this.withTargetPort(new IntOrString(strVal));
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNestedImpl();
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNestedImpl(item);
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort());
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : new IntOrStringBuilder().build());
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePortFluentImpl that = (ServicePortFluentImpl)o;
        if (this.appProtocol != null ? !this.appProtocol.equals(that.appProtocol) : that.appProtocol != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        return !(this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null);
    }

    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort, super.hashCode());
    }

    public class TargetPortNestedImpl<N>
    extends IntOrStringFluentImpl<ServicePortFluent.TargetPortNested<N>>
    implements ServicePortFluent.TargetPortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        TargetPortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        TargetPortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicePortFluentImpl.this.withTargetPort(this.builder.build());
        }

        @Override
        public N endTargetPort() {
            return this.and();
        }
    }
}

