/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_5.Nested;
import io.fabric8.kubernetes.api.model.v5_5.Quantity;
import io.fabric8.kubernetes.api.model.v5_5.QuantityBuilder;
import io.fabric8.kubernetes.api.model.v5_5.QuantityFluentImpl;
import io.fabric8.kubernetes.api.model.v5_5.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.v5_5.ResourceFieldSelectorFluent;
import java.util.Objects;

public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>>
extends BaseFluent<A>
implements ResourceFieldSelectorFluent<A> {
    private String containerName;
    private QuantityBuilder divisor;
    private String resource;

    public ResourceFieldSelectorFluentImpl() {
    }

    public ResourceFieldSelectorFluentImpl(ResourceFieldSelector instance) {
        this.withContainerName(instance.getContainerName());
        this.withDivisor(instance.getDivisor());
        this.withResource(instance.getResource());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    @Deprecated
    public A withNewContainerName(String arg0) {
        return this.withContainerName(new String(arg0));
    }

    @Override
    @Deprecated
    public Quantity getDivisor() {
        return this.divisor != null ? this.divisor.build() : null;
    }

    @Override
    public Quantity buildDivisor() {
        return this.divisor != null ? this.divisor.build() : null;
    }

    @Override
    public A withDivisor(Quantity divisor) {
        this._visitables.get("divisor").remove(this.divisor);
        if (divisor != null) {
            this.divisor = new QuantityBuilder(divisor);
            this._visitables.get("divisor").add(this.divisor);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDivisor() {
        return this.divisor != null;
    }

    @Override
    public A withNewDivisor(String amount, String format) {
        return this.withDivisor(new Quantity(amount, format));
    }

    @Override
    public A withNewDivisor(String amount) {
        return this.withDivisor(new Quantity(amount));
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor() {
        return new DivisorNestedImpl();
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item) {
        return new DivisorNestedImpl(item);
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor() {
        return this.withNewDivisorLike(this.getDivisor());
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisor() {
        return this.withNewDivisorLike(this.getDivisor() != null ? this.getDivisor() : new QuantityBuilder().build());
    }

    @Override
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisorLike(Quantity item) {
        return this.withNewDivisorLike(this.getDivisor() != null ? this.getDivisor() : item);
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    @Deprecated
    public A withNewResource(String arg0) {
        return this.withResource(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl)o;
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.divisor != null ? !this.divisor.equals(that.divisor) : that.divisor != null) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource, super.hashCode());
    }

    public class DivisorNestedImpl<N>
    extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>>
    implements ResourceFieldSelectorFluent.DivisorNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        DivisorNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        DivisorNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceFieldSelectorFluentImpl.this.withDivisor(this.builder.build());
        }

        @Override
        public N endDivisor() {
            return this.and();
        }
    }
}

