/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_5;

import io.fabric8.kubernetes.api.builder.v5_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v5_5.ObjectMetaFluentImpl;
import java.util.Objects;

public class ObjectMetaBuilder
extends ObjectMetaFluentImpl<ObjectMetaBuilder>
implements VisitableBuilder<ObjectMeta, ObjectMetaBuilder> {
    ObjectMetaFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectMetaBuilder() {
        this(true);
    }

    public ObjectMetaBuilder(Boolean validationEnabled) {
        this(new ObjectMeta(), validationEnabled);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectMeta(), validationEnabled);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance) {
        this(fluent, instance, true);
    }

    public ObjectMetaBuilder(ObjectMetaFluent<?> fluent, ObjectMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withClusterName(instance.getClusterName());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withFinalizers(instance.getFinalizers());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withGeneration(instance.getGeneration());
        fluent.withLabels(instance.getLabels());
        fluent.withManagedFields(instance.getManagedFields());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withOwnerReferences(instance.getOwnerReferences());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public ObjectMetaBuilder(ObjectMeta instance) {
        this(instance, (Boolean)true);
    }

    public ObjectMetaBuilder(ObjectMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withLabels(instance.getLabels());
        this.withManagedFields(instance.getManagedFields());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ObjectMeta build() {
        ObjectMeta buildable = new ObjectMeta(this.fluent.getAnnotations(), this.fluent.getClusterName(), this.fluent.getCreationTimestamp(), this.fluent.getDeletionGracePeriodSeconds(), this.fluent.getDeletionTimestamp(), this.fluent.getFinalizers(), this.fluent.getGenerateName(), this.fluent.getGeneration(), this.fluent.getLabels(), this.fluent.getManagedFields(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getOwnerReferences(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getUid());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaBuilder that = (ObjectMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

