/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_4.handlers.config;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_4.Infrastructure;
import io.fabric8.openshift.api.model.v5_4.InfrastructureBuilder;
import io.fabric8.openshift.clnt.v5_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_4.dsl.internal.config.InfrastructureOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class InfrastructureHandler
implements ResourceHandler<Infrastructure, InfrastructureBuilder> {
    @Override
    public String getKind() {
        return Infrastructure.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public Infrastructure create(OkHttpClient client, Config config, String namespace, Infrastructure item, boolean dryRun) {
        return (Infrastructure)((WritableOperation)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Infrastructure[0]);
    }

    @Override
    public Infrastructure replace(OkHttpClient client, Config config, String namespace, Infrastructure item, boolean dryRun) {
        return ((WritableOperation)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Infrastructure reload(OkHttpClient client, Config config, String namespace, Infrastructure item) {
        return (Infrastructure)((Gettable)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public InfrastructureBuilder edit(Infrastructure item) {
        return new InfrastructureBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Infrastructure item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, String resourceVersion, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, ListOptions options, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Infrastructure waitUntilReady(OkHttpClient client, Config config, String namespace, Infrastructure item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Infrastructure waitUntilCondition(OkHttpClient client, Config config, String namespace, Infrastructure item, Predicate<Infrastructure> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

