/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_4.handlers.config;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_4.APIServer;
import io.fabric8.openshift.api.model.v5_4.APIServerBuilder;
import io.fabric8.openshift.clnt.v5_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_4.dsl.internal.config.APIServerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class APIServerHandler
implements ResourceHandler<APIServer, APIServerBuilder> {
    @Override
    public String getKind() {
        return APIServer.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public APIServer create(OkHttpClient client, Config config, String namespace, APIServer item, boolean dryRun) {
        return (APIServer)((WritableOperation)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new APIServer[0]);
    }

    @Override
    public APIServer replace(OkHttpClient client, Config config, String namespace, APIServer item, boolean dryRun) {
        return ((WritableOperation)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public APIServer reload(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)((Gettable)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public APIServerBuilder edit(APIServer item) {
        return new APIServerBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, APIServer item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, Watcher<APIServer> watcher) {
        return ((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, String resourceVersion, Watcher<APIServer> watcher) {
        return ((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, ListOptions options, Watcher<APIServer> watcher) {
        return ((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public APIServer waitUntilReady(OkHttpClient client, Config config, String namespace, APIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public APIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, APIServer item, Predicate<APIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

