/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_4.handlers.apps;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_4.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_4.DeploymentConfigBuilder;
import io.fabric8.openshift.clnt.v5_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_4.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_4.dsl.internal.apps.DeploymentConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DeploymentConfigHandler
implements ResourceHandler<DeploymentConfig, DeploymentConfigBuilder> {
    @Override
    public String getKind() {
        return DeploymentConfig.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps.openshift.io/v1";
    }

    @Override
    public DeploymentConfig create(OkHttpClient client, Config config, String namespace, DeploymentConfig item, boolean dryRun) {
        return (DeploymentConfig)((WritableOperation)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new DeploymentConfig[0]);
    }

    @Override
    public DeploymentConfig replace(OkHttpClient client, Config config, String namespace, DeploymentConfig item, boolean dryRun) {
        return ((WritableOperation)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public DeploymentConfig reload(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
        return (DeploymentConfig)((Gettable)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DeploymentConfigBuilder edit(DeploymentConfig item) {
        return new DeploymentConfigBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, DeploymentConfig item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, String resourceVersion, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, ListOptions options, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public DeploymentConfig waitUntilReady(OkHttpClient client, Config config, String namespace, DeploymentConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public DeploymentConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Predicate<DeploymentConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

