/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.ListMeta;
import io.fabric8.openshift.api.model.v5_4.operator.v1.Console;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ConsoleBuilder;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ConsoleFluentImpl;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ConsoleList;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ConsoleListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConsoleListFluentImpl<A extends ConsoleListFluent<A>>
extends BaseFluent<A>
implements ConsoleListFluent<A> {
    private String apiVersion;
    private List<ConsoleBuilder> items = new ArrayList<ConsoleBuilder>();
    private String kind;
    private ListMeta metadata;

    public ConsoleListFluentImpl() {
    }

    public ConsoleListFluentImpl(ConsoleList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, Console item) {
        if (this.items == null) {
            this.items = new ArrayList<ConsoleBuilder>();
        }
        ConsoleBuilder builder = new ConsoleBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Console item) {
        if (this.items == null) {
            this.items = new ArrayList<ConsoleBuilder>();
        }
        ConsoleBuilder builder = new ConsoleBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Console ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ConsoleBuilder>();
        }
        for (Console item : items) {
            ConsoleBuilder builder = new ConsoleBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Console> items) {
        if (this.items == null) {
            this.items = new ArrayList<ConsoleBuilder>();
        }
        for (Console item : items) {
            ConsoleBuilder builder = new ConsoleBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Console ... items) {
        for (Console item : items) {
            ConsoleBuilder builder = new ConsoleBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Console> items) {
        for (Console item : items) {
            ConsoleBuilder builder = new ConsoleBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ConsoleBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ConsoleBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ConsoleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Console> getItems() {
        return ConsoleListFluentImpl.build(this.items);
    }

    @Override
    public List<Console> buildItems() {
        return ConsoleListFluentImpl.build(this.items);
    }

    @Override
    public Console buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Console buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Console buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Console buildMatchingItem(Predicate<ConsoleBuilder> predicate) {
        for (ConsoleBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ConsoleBuilder> predicate) {
        for (ConsoleBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Console> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ConsoleBuilder>();
            for (Console item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Console ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Console item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> addNewItemLike(Console item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> setNewItemLike(int index, Console item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ConsoleListFluent.ItemsNested<A> editMatchingItem(Predicate<ConsoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleListFluentImpl that = (ConsoleListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ConsoleFluentImpl<ConsoleListFluent.ItemsNested<N>>
    implements ConsoleListFluent.ItemsNested<N>,
    Nested<N> {
        private final ConsoleBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Console item) {
            this.index = index;
            this.builder = new ConsoleBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ConsoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

