/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.StorageSpecFluent;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.StorageSpecFluentImpl;
import java.util.Objects;

public class StorageSpecBuilder
extends StorageSpecFluentImpl<StorageSpecBuilder>
implements VisitableBuilder<StorageSpec, StorageSpecBuilder> {
    StorageSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StorageSpecBuilder() {
        this(true);
    }

    public StorageSpecBuilder(Boolean validationEnabled) {
        this(new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageSpec(), validationEnabled);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance) {
        this(fluent, instance, true);
    }

    public StorageSpecBuilder(StorageSpecFluent<?> fluent, StorageSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDisableMountSubPath(instance.getDisableMountSubPath());
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        this.validationEnabled = validationEnabled;
    }

    public StorageSpecBuilder(StorageSpec instance) {
        this(instance, (Boolean)true);
    }

    public StorageSpecBuilder(StorageSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDisableMountSubPath(instance.getDisableMountSubPath());
        this.withEmptyDir(instance.getEmptyDir());
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StorageSpec build() {
        StorageSpec buildable = new StorageSpec(this.fluent.getDisableMountSubPath(), this.fluent.getEmptyDir(), this.fluent.getVolumeClaimTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageSpecBuilder that = (StorageSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

