/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.Endpoint;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.EndpointBuilder;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.EndpointFluentImpl;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.NamespaceSelectorBuilder;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.NamespaceSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.ServiceMonitorSpec;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.ServiceMonitorSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceMonitorSpecFluentImpl<A extends ServiceMonitorSpecFluent<A>>
extends BaseFluent<A>
implements ServiceMonitorSpecFluent<A> {
    private List<EndpointBuilder> endpoints = new ArrayList<EndpointBuilder>();
    private String jobLabel;
    private NamespaceSelectorBuilder namespaceSelector;
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private LabelSelectorBuilder selector;
    private List<String> targetLabels = new ArrayList<String>();

    public ServiceMonitorSpecFluentImpl() {
    }

    public ServiceMonitorSpecFluentImpl(ServiceMonitorSpec instance) {
        this.withEndpoints(instance.getEndpoints());
        this.withJobLabel(instance.getJobLabel());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodTargetLabels(instance.getPodTargetLabels());
        this.withSampleLimit(instance.getSampleLimit());
        this.withSelector(instance.getSelector());
        this.withTargetLabels(instance.getTargetLabels());
    }

    @Override
    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        this._visitables.get("endpoints").add(index >= 0 ? index : this._visitables.get("endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("endpoints").size()) {
            this._visitables.get("endpoints").add(builder);
        } else {
            this._visitables.get("endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(Endpoint ... items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Endpoint> getEndpoints() {
        return ServiceMonitorSpecFluentImpl.build(this.endpoints);
    }

    @Override
    public List<Endpoint> buildEndpoints() {
        return ServiceMonitorSpecFluentImpl.build(this.endpoints);
    }

    @Override
    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public String getJobLabel() {
        return this.jobLabel;
    }

    @Override
    public A withJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return (A)this;
    }

    @Override
    public Boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    @Override
    @Deprecated
    public A withNewJobLabel(String arg0) {
        return this.withJobLabel(new String(arg0));
    }

    @Override
    @Deprecated
    public NamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new NamespaceSelectorBuilder().build());
    }

    @Override
    public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    public A addToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodTargetLabels(String ... items) {
        for (String item : items) {
            if (this.podTargetLabels == null) continue;
            this.podTargetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodTargetLabels(Collection<String> items) {
        for (String item : items) {
            if (this.podTargetLabels == null) continue;
            this.podTargetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    @Override
    public String getPodTargetLabel(int index) {
        return this.podTargetLabels.get(index);
    }

    @Override
    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    @Override
    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(this.podTargetLabels.size() - 1);
    }

    @Override
    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (this.podTargetLabels != null) {
            this._visitables.get("podTargetLabels").removeAll(this.podTargetLabels);
        }
        if (podTargetLabels != null) {
            this.podTargetLabels = new ArrayList<String>();
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        } else {
            this.podTargetLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withPodTargetLabels(String ... podTargetLabels) {
        if (this.podTargetLabels != null) {
            this.podTargetLabels.clear();
        }
        if (podTargetLabels != null) {
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodTargetLabels() {
        return this.podTargetLabels != null && !this.podTargetLabels.isEmpty();
    }

    @Override
    public A addNewPodTargetLabel(String arg0) {
        return this.addToPodTargetLabels(new String(arg0));
    }

    @Override
    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    @Override
    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public A addToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargetLabels(int index, String item) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        this.targetLabels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargetLabels(String ... items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargetLabels(Collection<String> items) {
        if (this.targetLabels == null) {
            this.targetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargetLabels(String ... items) {
        for (String item : items) {
            if (this.targetLabels == null) continue;
            this.targetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargetLabels(Collection<String> items) {
        for (String item : items) {
            if (this.targetLabels == null) continue;
            this.targetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargetLabels() {
        return this.targetLabels;
    }

    @Override
    public String getTargetLabel(int index) {
        return this.targetLabels.get(index);
    }

    @Override
    public String getFirstTargetLabel() {
        return this.targetLabels.get(0);
    }

    @Override
    public String getLastTargetLabel() {
        return this.targetLabels.get(this.targetLabels.size() - 1);
    }

    @Override
    public String getMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTargetLabel(Predicate<String> predicate) {
        for (String item : this.targetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargetLabels(List<String> targetLabels) {
        if (this.targetLabels != null) {
            this._visitables.get("targetLabels").removeAll(this.targetLabels);
        }
        if (targetLabels != null) {
            this.targetLabels = new ArrayList<String>();
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        } else {
            this.targetLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withTargetLabels(String ... targetLabels) {
        if (this.targetLabels != null) {
            this.targetLabels.clear();
        }
        if (targetLabels != null) {
            for (String item : targetLabels) {
                this.addToTargetLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetLabels() {
        return this.targetLabels != null && !this.targetLabels.isEmpty();
    }

    @Override
    public A addNewTargetLabel(String arg0) {
        return this.addToTargetLabels(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl)o;
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.jobLabel != null ? !this.jobLabel.equals(that.jobLabel) : that.jobLabel != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.podTargetLabels != null ? !this.podTargetLabels.equals(that.podTargetLabels) : that.podTargetLabels != null) {
            return false;
        }
        if (this.sampleLimit != null ? !this.sampleLimit.equals(that.sampleLimit) : that.sampleLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.targetLabels != null ? !this.targetLabels.equals(that.targetLabels) : that.targetLabels != null);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.jobLabel, this.namespaceSelector, this.podTargetLabels, this.sampleLimit, this.selector, this.targetLabels, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ServiceMonitorSpecFluent.SelectorNested<N>>
    implements ServiceMonitorSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceMonitorSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNestedImpl<N>
    extends NamespaceSelectorFluentImpl<ServiceMonitorSpecFluent.NamespaceSelectorNested<N>>
    implements ServiceMonitorSpecFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        private final NamespaceSelectorBuilder builder;

        NamespaceSelectorNestedImpl(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new NamespaceSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceMonitorSpecFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends EndpointFluentImpl<ServiceMonitorSpecFluent.EndpointsNested<N>>
    implements ServiceMonitorSpecFluent.EndpointsNested<N>,
    Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceMonitorSpecFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

