/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v5_4.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_4.Status;
import io.fabric8.kubernetes.api.model.v5_4.StatusBuilder;
import io.fabric8.kubernetes.api.model.v5_4.StatusCause;
import io.fabric8.kubernetes.api.model.v5_4.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.v5_4.StatusFluent;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_4.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.clnt.v5_4.server.mock.KubernetesCrudAttributesExtractor;
import io.fabric8.kubernetes.clnt.v5_4.server.mock.KubernetesResponseComposer;
import io.fabric8.kubernetes.clnt.v5_4.server.mock.WatchEventsListener;
import io.fabric8.kubernetes.clnt.v5_4.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_4.utils.Utils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.CrudDispatcher;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import io.fabric8.zjsonpatch.JsonDiff;
import io.fabric8.zjsonpatch.JsonPatch;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCrudDispatcher
extends CrudDispatcher {
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String PATCH = "PATCH";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    private static final String ADDED = "ADDED";
    private static final String MODIFIED = "MODIFIED";
    private static final String STATUS = "status";
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesCrudDispatcher.class);
    public static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private final Set<WatchEventsListener> watchEventListeners = new CopyOnWriteArraySet<WatchEventsListener>();

    public KubernetesCrudDispatcher() {
        this(Collections.emptyList());
    }

    public KubernetesCrudDispatcher(List<CustomResourceDefinitionContext> crdContexts) {
        this(new KubernetesCrudAttributesExtractor(crdContexts), new KubernetesResponseComposer());
    }

    public KubernetesCrudDispatcher(KubernetesCrudAttributesExtractor attributeExtractor, ResponseComposer responseComposer) {
        super(new Context(Serialization.jsonMapper()), (AttributeExtractor)attributeExtractor, responseComposer);
    }

    public synchronized MockResponse dispatch(RecordedRequest request) {
        String path = request.getPath();
        String method = request.getMethod();
        switch (method.toUpperCase()) {
            case "POST": {
                return this.handleCreate(path, request.getBody().readUtf8());
            }
            case "PUT": {
                return this.handleReplace(path, request.getBody().readUtf8());
            }
            case "PATCH": {
                return this.handlePatch(path, request.getBody().readUtf8());
            }
            case "GET": {
                return this.detectWatchMode(path) ? this.handleWatch(path) : this.handleGet(path);
            }
            case "DELETE": {
                return this.handleDelete(path);
            }
        }
        return null;
    }

    public MockResponse handleCreate(String path, String s) {
        return this.validateRequestBodyAndHandleRequest(s, () -> this.doCreateOrModify(path, s, ADDED));
    }

    public MockResponse handleReplace(String path, String s) {
        return this.validateRequestBodyAndHandleRequest(s, () -> this.doCreateOrModify(path, s, MODIFIED));
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> {
            LOGGER.debug("Entry found for query {} : {}", (Object)query, entry);
            items.add(entry.getValue());
        });
        if (query.containsKey("name")) {
            if (!items.isEmpty()) {
                response.setBody((String)items.get(0));
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        } else {
            response.setBody(this.responseComposer.compose(items));
            response.setResponseCode(200);
        }
        return response;
    }

    public MockResponse handlePatch(String path, String s) {
        MockResponse response = new MockResponse();
        String body = this.fetchResource(path);
        if (body == null) {
            response.setResponseCode(404);
        } else {
            try {
                JsonNode patch = this.context.getMapper().readTree(s);
                JsonNode source = this.context.getMapper().readTree(body);
                JsonNode status = this.removeStatus(source);
                JsonNode updated = JsonPatch.apply((JsonNode)patch, (JsonNode)source);
                if (status == null) {
                    this.removeStatus(updated);
                } else {
                    ((ObjectNode)updated).set(STATUS, status);
                }
                String updatedAsString = this.context.getMapper().writeValueAsString((Object)updated);
                AttributeSet query = this.attributeExtractor.fromPath(path);
                AttributeSet attributeSet = (AttributeSet)this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).findFirst().orElseThrow(IllegalStateException::new).getKey();
                this.map.remove(attributeSet);
                AttributeSet newAttributeSet = AttributeSet.merge((AttributeSet[])new AttributeSet[]{attributeSet, this.attributeExtractor.fromResource(updatedAsString)});
                this.map.put(newAttributeSet, updatedAsString);
                AtomicBoolean flag = new AtomicBoolean(false);
                AttributeSet finalAttributeSet = attributeSet;
                this.watchEventListeners.stream().filter(watchEventsListener -> watchEventsListener.attributeMatches(finalAttributeSet)).forEach(watchEventsListener -> {
                    flag.set(true);
                    watchEventsListener.sendWebSocketResponse(updatedAsString, MODIFIED);
                });
                if (!flag.get()) {
                    this.watchEventListeners.stream().filter(watchEventsListener -> watchEventsListener.attributeMatches(newAttributeSet)).forEach(watchEventsListener -> watchEventsListener.sendWebSocketResponse(updatedAsString, ADDED));
                }
                response.setResponseCode(202);
                response.setBody(updatedAsString);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return response;
    }

    public MockResponse handleDelete(String path) {
        return new MockResponse().setResponseCode(this.doDelete(path, "DELETED"));
    }

    public MockResponse handleWatch(String path) {
        MockResponse mockResponse = new MockResponse();
        String resourceName = this.fetchResourceNameFromWatchRequestPath(path);
        AttributeSet query = this.attributeExtractor.fromPath(path);
        if (resourceName != null) {
            query = query.add(new Attribute[]{new Attribute("name", resourceName)});
        }
        WatchEventsListener watchEventListener = new WatchEventsListener(this.context, query, this.watchEventListeners, LOGGER, watch -> this.map.entrySet().stream().filter(entry -> watch.attributeMatches((AttributeSet)entry.getKey())).forEach(entry -> watch.sendWebSocketResponse((String)entry.getValue(), ADDED)));
        this.watchEventListeners.add(watchEventListener);
        mockResponse.setSocketPolicy(SocketPolicy.KEEP_OPEN);
        return mockResponse.withWebSocketUpgrade((WebSocketListener)watchEventListener);
    }

    private boolean detectWatchMode(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("incorrect URI string: [{}]", (Object)path);
            return false;
        }
        if (queryString != null && !queryString.isEmpty()) {
            return queryString.contains("watch=true");
        }
        return false;
    }

    private String fetchResourceNameFromWatchRequestPath(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Incorrect URI string: [{}]", (Object)path);
            return null;
        }
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String name = "";
        for (String q : queryString.split("&")) {
            if (!q.contains("fieldSelector") || !q.contains("metadata.name")) continue;
            String[] s = q.split("=");
            name = s[s.length - 1];
        }
        return name.isEmpty() ? null : name;
    }

    private String fetchResource(String path) {
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> items.add(entry.getValue()));
        if (items.isEmpty()) {
            return null;
        }
        if (items.size() == 1) {
            return (String)items.get(0);
        }
        return this.responseComposer.compose(items);
    }

    private int doDelete(String path, String event) {
        List<AttributeSet> items = this.findItems(this.attributeExtractor.fromPath(path));
        if (items.isEmpty()) {
            return 404;
        }
        items.forEach(item -> {
            if (event != null && !event.isEmpty()) {
                this.watchEventListeners.stream().filter(listener -> listener.attributeMatches((AttributeSet)item)).forEach(listener -> listener.sendWebSocketResponse((String)this.map.get(item), event));
            }
            this.map.remove(item);
        });
        return 200;
    }

    private List<AttributeSet> findItems(AttributeSet query) {
        return this.map.keySet().stream().filter(entry -> entry.matches(query)).collect(Collectors.toList());
    }

    private MockResponse doCreateOrModify(String path, String initial, String event) {
        MockResponse mockResponse = new MockResponse();
        AttributeSet attributes = this.attributeExtractor.fromPath(path);
        try {
            List<AttributeSet> items;
            HasMetadata h;
            JsonNode source = this.context.getMapper().readTree(initial);
            JsonNode status = this.removeStatus(source);
            int responseCode = 200;
            if (ADDED.equals(event) && (h = KubernetesAttributesExtractor.toKubernetesResource(this.context.getMapper().writeValueAsString((Object)source))) != null && h.getMetadata() != null && h.getMetadata().getName() != null) {
                attributes = AttributeSet.merge((AttributeSet[])new AttributeSet[]{attributes, new AttributeSet(new Attribute[]{new Attribute("name", h.getMetadata().getName())})});
            }
            if ((items = this.findItems(attributes)).isEmpty()) {
                if (MODIFIED.equals(event)) {
                    responseCode = 404;
                } else {
                    this.setDefaultMetadata(source, attributes, null);
                }
            } else if (ADDED.equals(event)) {
                responseCode = 409;
            } else if (MODIFIED.equals(event)) {
                String existing = (String)this.map.remove(items.get(0));
                JsonNode existingNode = this.context.getMapper().readTree(existing);
                if (KubernetesCrudDispatcher.isStatusPath(path)) {
                    source = existingNode;
                } else {
                    status = this.removeStatus(existingNode);
                    this.setDefaultMetadata(source, attributes, existingNode.findValue("metadata"));
                }
                if (status != null) {
                    ((ObjectNode)source).set(STATUS, status);
                } else {
                    ((ObjectNode)source).remove(STATUS);
                }
                existingNode = this.context.getMapper().readTree(existing);
                if (JsonDiff.asJson((JsonNode)source, (JsonNode)existingNode).isEmpty()) {
                    event = null;
                }
            }
            if (responseCode == 200) {
                String s = this.context.getMapper().writeValueAsString((Object)source);
                AttributeSet features = AttributeSet.merge((AttributeSet[])new AttributeSet[]{attributes, this.attributeExtractor.fromResource(s)});
                this.map.put(features, s);
                if (event != null && !event.isEmpty()) {
                    String response = s;
                    String finalEvent = event;
                    this.watchEventListeners.stream().filter(listener -> listener.attributeMatches(features)).forEach(listener -> listener.sendWebSocketResponse(response, finalEvent));
                }
                mockResponse.setBody(s);
            }
            mockResponse.setResponseCode(responseCode);
            return mockResponse;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isStatusPath(String path) {
        return path.endsWith("/status");
    }

    private void setDefaultMetadata(JsonNode source, AttributeSet fromPath, JsonNode exitingMetadata) throws JsonProcessingException {
        ObjectNode metadata = (ObjectNode)source.findValue("metadata");
        UUID uuid = UUID.randomUUID();
        if (metadata.get("name") == null) {
            metadata.put("name", metadata.get("generateName").asText() + "-" + uuid.toString());
        }
        metadata.put("uid", this.getOrDefault(exitingMetadata, "uid", uuid.toString()));
        metadata.put("resourceVersion", "1");
        metadata.put("generation", 1);
        metadata.put("creationTimestamp", this.getOrDefault(exitingMetadata, "creationTimestamp", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT)));
    }

    private String getOrDefault(JsonNode node, String name, String defaultValue) {
        JsonNode field;
        if (node != null && (field = node.get(name)) != null) {
            return field.asText();
        }
        return defaultValue;
    }

    private JsonNode removeStatus(JsonNode source) {
        return ((ObjectNode)source).remove(STATUS);
    }

    private MockResponse validateRequestBodyAndHandleRequest(String s, Supplier<MockResponse> mockResponseSupplier) {
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            try {
                this.validateResource(h);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.getUnprocessableEntityMockResponse(s, h, illegalArgumentException);
            }
        }
        return mockResponseSupplier.get();
    }

    private MockResponse getUnprocessableEntityMockResponse(String s, HasMetadata h, IllegalArgumentException illegalArgumentException) {
        String statusBody = this.getStatusBody(h, 422, illegalArgumentException);
        if (statusBody == null) {
            statusBody = s;
        }
        return new MockResponse().setResponseCode(422).setBody(statusBody);
    }

    private String getStatusBody(HasMetadata h, int code, IllegalArgumentException illegalArgumentException) {
        String kind = Utils.getNonNullOrElse(h.getKind(), "Unknown");
        Status status = ((StatusBuilder)((StatusBuilder)((StatusFluent.DetailsNested)((StatusFluent.DetailsNested)((StatusBuilder)((StatusBuilder)((StatusBuilder)new StatusBuilder().withStatus("Failure")).withReason("Invalid")).withMessage(kind + " is invalid")).withNewDetails().withKind(h.getKind())).withCauses(this.getFailureStatusCause(illegalArgumentException))).endDetails()).withCode(code)).build();
        try {
            return Serialization.jsonMapper().writeValueAsString((Object)status);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private StatusCause getFailureStatusCause(IllegalArgumentException illegalArgumentException) {
        return ((StatusCauseBuilder)((StatusCauseBuilder)new StatusCauseBuilder().withMessage(illegalArgumentException.getMessage())).withReason("ValueRequired")).build();
    }

    private void validateResource(HasMetadata item) {
        if (item == null) {
            throw new IllegalArgumentException("No item provided");
        }
        if (item.getMetadata() == null) {
            throw new IllegalArgumentException("Required value: metadata is required");
        }
        if (Utils.isNullOrEmpty(item.getMetadata().getName()) && Utils.isNullOrEmpty(item.getMetadata().getGenerateName())) {
            throw new IllegalArgumentException("Required value: name or generateName is required");
        }
    }
}

