/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.api.model.v5_4.Node;
import io.fabric8.kubernetes.api.model.v5_4.NodeBuilder;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.core.v1.NodeOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NodeHandler
implements ResourceHandler<Node, NodeBuilder> {
    @Override
    public String getKind() {
        return Node.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Node create(OkHttpClient client, Config config, String namespace, Node item, boolean dryRun) {
        return (Node)((WritableOperation)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Node[0]);
    }

    @Override
    public Node replace(OkHttpClient client, Config config, String namespace, Node item, boolean dryRun) {
        return ((WritableOperation)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Node reload(OkHttpClient client, Config config, String namespace, Node item) {
        return (Node)((Gettable)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NodeBuilder edit(Node item) {
        return new NodeBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Node item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new NodeOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Node item, Watcher<Node> watcher) {
        return ((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Node item, String resourceVersion, Watcher<Node> watcher) {
        return ((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Node item, ListOptions options, Watcher<Node> watcher) {
        return ((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Node waitUntilReady(OkHttpClient client, Config config, String namespace, Node item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Node)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Node waitUntilCondition(OkHttpClient client, Config config, String namespace, Node item, Predicate<Node> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Node)((Resource)new NodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

