/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.handlers.apps.v1;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.api.model.v5_4.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_4.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StatefulSetHandler
implements ResourceHandler<StatefulSet, StatefulSetBuilder> {
    @Override
    public String getKind() {
        return StatefulSet.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public StatefulSet create(OkHttpClient client, Config config, String namespace, StatefulSet item, boolean dryRun) {
        return (StatefulSet)((WritableOperation)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new StatefulSet[0]);
    }

    @Override
    public StatefulSet replace(OkHttpClient client, Config config, String namespace, StatefulSet item, boolean dryRun) {
        return ((WritableOperation)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public StatefulSet reload(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((Gettable)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StatefulSetBuilder edit(StatefulSet item) {
        return new StatefulSetBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, StatefulSet item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new StatefulSetOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, Watcher<StatefulSet> watcher) {
        return ((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, String resourceVersion, Watcher<StatefulSet> watcher) {
        return ((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, ListOptions options, Watcher<StatefulSet> watcher) {
        return ((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public StatefulSet waitUntilReady(OkHttpClient client, Config config, String namespace, StatefulSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StatefulSet waitUntilCondition(OkHttpClient client, Config config, String namespace, StatefulSet item, Predicate<StatefulSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

