/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.AbstractWatchManager;
import okhttp3.HttpUrl;
import okhttp3.Request;

class RawRequestBuilder
implements AbstractWatchManager.RequestBuilder {
    private final HttpUrl.Builder watchUrlBuilder;

    public RawRequestBuilder(HttpUrl.Builder watchUrlBuilder) {
        this.watchUrlBuilder = watchUrlBuilder;
    }

    @Override
    public Request build(String resourceVersion) {
        if (resourceVersion != null) {
            this.watchUrlBuilder.removeAllQueryParameters("resourceVersion");
            this.watchUrlBuilder.addQueryParameter("resourceVersion", resourceVersion);
        }
        HttpUrl watchUrl = this.watchUrlBuilder.build();
        String origin = watchUrl.url().getProtocol() + "://" + watchUrl.url().getHost();
        if (watchUrl.url().getPort() != -1) {
            origin = origin + ":" + watchUrl.url().getPort();
        }
        return new Request.Builder().get().url(watchUrl).addHeader("Origin", origin).build();
    }
}

