/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.dsl.base;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v5_4.Visitor;
import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_4.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_4.ObjectMeta;
import io.fabric8.kubernetes.clnt.v5_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.PatchType;
import io.fabric8.kubernetes.clnt.v5_4.utils.IOHelpers;
import io.fabric8.kubernetes.clnt.v5_4.utils.Serialization;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends BaseOperation<T, L, R> {
    private static final String NO_BUILDER = "Cannot edit with visitors, no builder is associated";
    public static final DeletionPropagation DEFAULT_PROPAGATION_POLICY = DeletionPropagation.BACKGROUND;
    public static final long DEFAULT_GRACE_PERIOD_IN_SECONDS = -1L;
    private static final String PATCH_OPERATION = "patch";

    public HasMetadataOperation(OperationContext ctx) {
        super(ctx);
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        Object item = this.getMandatory();
        HasMetadata clone = (HasMetadata)Serialization.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)function.apply(item), false);
    }

    @Override
    public T editStatus(UnaryOperator<T> function) {
        Object item = this.getMandatory();
        HasMetadata clone = (HasMetadata)Serialization.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)function.apply(item), true);
    }

    @Override
    public T accept(Consumer<T> consumer) {
        Object item = this.getMandatory();
        HasMetadata clone = (HasMetadata)Serialization.clone(item);
        consumer.accept(item);
        return (T)this.patch(null, clone, item, false);
    }

    protected VisitableBuilder<T, ?> createVisitableBuilder(T item) {
        throw new KubernetesClientException(NO_BUILDER);
    }

    @Override
    public T edit(Visitor ... visitors) {
        Object item = this.getMandatory();
        HasMetadata clone = (HasMetadata)Serialization.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)((VisitableBuilder)this.createVisitableBuilder(item).accept(visitors)).build(), false);
    }

    protected Gettable<T> fromServer(ObjectMeta metadata) {
        if (this.getName() != null) {
            return this.fromServer();
        }
        if (metadata != null) {
            return (Gettable)this.withName(metadata.getName()).fromServer();
        }
        throw new KubernetesClientException("Name not specified. But operation requires name.");
    }

    @Override
    public T replace(T item) {
        return this.replace(item, false);
    }

    @Override
    public T replaceStatus(T item) {
        return this.replace(item, true);
    }

    protected T replace(T item, boolean status) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else {
                    HasMetadata got = (HasMetadata)this.fromServer(item.getMetadata()).get();
                    if (got == null) {
                        return null;
                    }
                    resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                }
                UnaryOperator visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleUpdate(resource, status);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
                    }
                };
                return (T)((HasMetadata)visitor.apply(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)caught);
    }

    protected T patch(PatchContext context, T base, T item, boolean status) {
        if (base == null && context != null && context.getPatchType() == PatchType.JSON) {
            base = (HasMetadata)this.fromServer(item.getMetadata()).get();
            if (base == null) {
                return null;
            }
            if (item.getMetadata() == null) {
                item.setMetadata(new ObjectMeta());
            }
            if (base.getMetadata() != null) {
                item.getMetadata().setResourceVersion(base.getMetadata().getResourceVersion());
            }
        }
        T theBase = base;
        UnaryOperator visitor = resource -> {
            try {
                return this.handlePatch(context, theBase, resource, status);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)e);
            }
        };
        return (T)((HasMetadata)visitor.apply(item));
    }

    @Override
    public T patchStatus(T item) {
        return this.patch(new PatchContext.Builder().withPatchType(PatchType.JSON_MERGE).build(), null, item, true);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        return this.patch(patchContext, null, item, false);
    }

    @Override
    public T patch(PatchContext patchContext, String patch) {
        try {
            HasMetadata got = (HasMetadata)this.fromServer().get();
            if (got == null) {
                return null;
            }
            return (T)this.handlePatch(patchContext, got, IOHelpers.convertToJson(patch), this.getType(), false);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)interruptedException);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)e);
        }
    }
}

